/*
 * Decompiled with CFR 0.152.
 */
package org.bacza.http;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import okhttp3.Response;
import org.bacza.http.ResponseUtils;
import org.bacza.utils.AssertUtils;

public class WebResponse
implements Closeable {
    private Response response;

    public WebResponse(Response response) {
        AssertUtils.notNull(response, "HTTP response");
        this.response = response;
    }

    @Override
    public void close() throws IOException {
        this.response.close();
    }

    public URI getLastURI() {
        return ResponseUtils.getLastURI(this.response);
    }

    public String getContentType() {
        return ResponseUtils.getContentType(this.response);
    }

    public String getContentText() throws IOException {
        return ResponseUtils.getContentText(this.response);
    }
}

