/*
 * Decompiled with CFR 0.152.
 */
package org.bacza.http;

import java.util.List;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.bacza.http.EntityUtils;
import org.bacza.utils.StringPair;
import org.json.JSONObject;

public final class RequestUtils {
    public static final MediaType JSON = MediaType.parse((String)"application/json");

    public static Request get(String url) {
        return RequestUtils.get(url, null);
    }

    public static Request get(String url, List<StringPair> headers) {
        Request.Builder builder = new Request.Builder();
        builder.url(url);
        if (headers != null) {
            for (StringPair header : headers) {
                builder.addHeader((String)header.getKey(), (String)header.getValue());
            }
        }
        return builder.build();
    }

    public static Request post(String url, List<StringPair> params) {
        FormBody body = EntityUtils.createFormBody(params);
        Request request = new Request.Builder().url(url).post((RequestBody)body).build();
        return request;
    }

    public static Request post(String url, List<StringPair> headers, JSONObject payload) {
        RequestBody body = RequestBody.create((MediaType)JSON, (String)payload.toString());
        Request.Builder builder = new Request.Builder();
        builder.url(url);
        builder.post(body);
        if (headers != null) {
            for (StringPair header : headers) {
                builder.addHeader((String)header.getKey(), (String)header.getValue());
            }
        }
        return builder.build();
    }

    public static Request delete(String url) {
        return RequestUtils.delete(url, null);
    }

    public static Request delete(String url, List<StringPair> headers) {
        Request.Builder builder = new Request.Builder();
        builder.url(url);
        builder.delete();
        if (headers != null) {
            for (StringPair header : headers) {
                builder.addHeader((String)header.getKey(), (String)header.getValue());
            }
        }
        return builder.build();
    }
}

