/*
 * Decompiled with CFR 0.152.
 */
package org.bacza.http;

import java.io.IOException;
import okhttp3.Response;

public class HttpResponseException
extends IOException {
    private static final long serialVersionUID = -4849239706646729137L;
    private final int statusCode;
    private final String statusMessage;
    private final String details;

    public HttpResponseException(Response response) {
        this(response, null);
    }

    public HttpResponseException(Response response, String details) {
        super(String.format("%d %s", response.code(), response.message()));
        this.statusCode = response.code();
        this.statusMessage = response.message();
        this.details = details;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getstatusMessage() {
        return this.statusMessage;
    }

    public String getDetails() {
        return this.details;
    }

    public boolean is3xxError() {
        return this.statusCode >= 300 && this.statusCode <= 399;
    }

    public boolean is4xxError() {
        return this.statusCode >= 400 && this.statusCode <= 499;
    }

    public boolean is5xxError() {
        return this.statusCode >= 500 && this.statusCode <= 599;
    }

    public boolean isBadRequest() {
        return this.statusCode == 400;
    }

    public boolean isUnauthorized() {
        return this.statusCode == 401;
    }

    public boolean isServerError() {
        return this.statusCode == 500;
    }
}

