/*
 * Decompiled with CFR 0.152.
 */
package org.bacza.http;

import geocentral.common.app.ConfigDataService;
import geocentral.common.app.IConfigData;
import geocentral.common.app.UserProfile;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import okhttp3.Cookie;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bacza.data.json.JSONUtils;
import org.bacza.http.PersistentCookieJar;
import org.bacza.utils.AssertUtils;
import org.bacza.utils.StringUtils;
import org.bacza.utils.Timer;
import org.json.JSONArray;
import org.json.JSONObject;

public class FileCookieJar
extends PersistentCookieJar {
    private Log log = LogFactory.getLog(FileCookieJar.class);
    private static final String FILE_NAME = "system-data-1.dat";
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
    private final Object lock;
    private final String uuid;
    private final IConfigData data;
    private int changeNum;
    private Timer timer;

    static {
        DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public FileCookieJar(UserProfile profile) {
        this(profile, 1000L);
    }

    public FileCookieJar(UserProfile profile, long saveDelay) {
        AssertUtils.notNull(profile, "profile");
        this.lock = new Object();
        this.uuid = profile.getUUID().toString();
        this.data = ConfigDataService.getInstance().getSystemData(FILE_NAME, true);
        this.changeNum = 0;
        this.timer = new Timer("Cookie Sync", saveDelay, new Runnable(){

            @Override
            public void run() {
                FileCookieJar.this.timerCallback();
            }
        });
    }

    private void timerCallback() {
        try {
            this.saveCookies();
        }
        catch (IOException e) {
            this.log.debug((Object)("Error saving cookies: " + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markChange() {
        Object object = this.lock;
        synchronized (object) {
            ++this.changeNum;
        }
        this.timer.restart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearChangeAfterSave(int changeNumStart) {
        Object object = this.lock;
        synchronized (object) {
            if (changeNumStart == this.changeNum) {
                this.changeNum = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getChangeNum() {
        Object object = this.lock;
        synchronized (object) {
            return this.changeNum;
        }
    }

    private boolean isChanged() {
        return this.getChangeNum() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveCookies() throws IOException {
        int changeNumStart = this.getChangeNum();
        List<Cookie> cookies = this.getCookies();
        IConfigData iConfigData = this.data;
        synchronized (iConfigData) {
            JSONObject root = this.data.getObject(this.uuid);
            JSONArray array = JSONUtils.createArray(root, "cookies");
            for (Cookie cookie : cookies) {
                if (!cookie.persistent()) continue;
                JSONObject c = JSONUtils.createObject(array);
                c.put("name", (Object)cookie.name());
                c.put("value", (Object)cookie.value());
                c.put("domain", (Object)cookie.domain());
                c.put("path", (Object)cookie.path());
                c.put("exp", (Object)DATE_FORMAT.format(new Date(cookie.expiresAt())));
                if (cookie.secure()) {
                    c.put("secure", true);
                }
                if (cookie.httpOnly()) {
                    c.put("httpOnly", true);
                }
                if (!cookie.hostOnly()) continue;
                c.put("hostOnly", true);
            }
            this.data.save();
        }
        this.clearChangeAfterSave(changeNumStart);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCookies() throws IOException {
        IConfigData iConfigData = this.data;
        synchronized (iConfigData) {
            JSONObject root = this.data.getObject(this.uuid);
            JSONArray array = root.optJSONArray("cookies");
            if (array == null) {
                return;
            }
            int i = 0;
            while (i < array.length()) {
                JSONObject c = array.getJSONObject(i);
                try {
                    Cookie.Builder builder = new Cookie.Builder();
                    builder.name(c.getString("name"));
                    builder.value(c.getString("value"));
                    String domain = c.getString("domain");
                    builder.domain(domain);
                    String str = c.optString("path");
                    if (StringUtils.notEmpty(str)) {
                        builder.path(str);
                    }
                    if (StringUtils.notEmpty(str = c.optString("exp"))) {
                        builder.expiresAt(DATE_FORMAT.parse(str).getTime());
                    }
                    if (c.optBoolean("secure")) {
                        builder.secure();
                    }
                    if (c.optBoolean("httpOnly")) {
                        builder.httpOnly();
                    }
                    if (c.optBoolean("hostOnly")) {
                        builder.hostOnlyDomain(domain);
                    }
                    this.addCookie(builder.build());
                }
                catch (Exception e) {
                    this.log.debug((Object)("Error loading cookie: " + e.getMessage()));
                }
                ++i;
            }
        }
    }

    @Override
    protected void onLoad() throws IOException {
        this.loadCookies();
    }

    @Override
    protected void onClose() throws IOException {
        this.timer.stop();
        if (this.isChanged()) {
            this.saveCookies();
        }
    }

    @Override
    protected void onCookieAdd(Cookie cookie) {
        this.markChange();
    }

    @Override
    protected void onCookieUpdate(Cookie cookie) {
        this.markChange();
    }

    @Override
    protected void onCookieRemove(Cookie cookie) {
        this.markChange();
    }

    @Override
    protected void onClear() {
        this.markChange();
    }
}

