/*
 * Decompiled with CFR 0.152.
 */
package org.bacza.events;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;

public class ListenerList<T extends EventListener> {
    private final List<T> listeners = new ArrayList<T>();
    private List<T> listenersCache = this.createListenersCache(this.listeners);

    private List<T> createListenersCache(List<T> listeners) {
        return Collections.unmodifiableList(new ArrayList<T>(listeners));
    }

    public synchronized void addListener(T listener) {
        if (listener != null) {
            this.listeners.add(listener);
            this.listenersCache = this.createListenersCache(this.listeners);
        }
    }

    public synchronized void removeListener(T listener) {
        if (listener != null) {
            this.listeners.remove(listener);
            this.listenersCache = this.createListenersCache(this.listeners);
        }
    }

    public synchronized List<T> getListeners() {
        return this.listenersCache;
    }

    public synchronized int size() {
        return this.listeners.size();
    }
}

