/*
 * Decompiled with CFR 0.152.
 */
package org.bacza.data.html;

import java.util.List;
import org.bacza.data.html.FormElement;
import org.bacza.data.html.FormValueOption;
import org.bacza.data.html.Tag;
import org.jsoup.nodes.Element;

public class TextareaTag
extends Tag
implements FormElement {
    private String text;

    public TextareaTag() {
    }

    public TextareaTag(Element element) {
        super(element);
        this.initializeValue(element);
    }

    private void initializeValue(Element element) {
        if (element != null) {
            this.setText(element.ownText());
        }
    }

    @Override
    public String getName() {
        return this.getAttrName();
    }

    @Override
    public String getType() {
        return "textarea";
    }

    @Override
    public boolean isSelectable() {
        return false;
    }

    @Override
    public boolean isMultiSelectable() {
        return false;
    }

    @Override
    public String getValue() {
        return this.getText();
    }

    @Override
    public List<FormValueOption> getOptions() {
        return null;
    }

    public String getAttrName() {
        return this.getAttribute("name");
    }

    public void setAttrName(String name) {
        this.setAttribute("name", name);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public String toString() {
        return String.format("textarea: name=%s", this.getName());
    }
}

