/*
 * Decompiled with CFR 0.152.
 */
package org.bacza.data.html;

import java.util.HashMap;
import java.util.Map;
import org.bacza.utils.StringUtils;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Element;

public class Tag {
    private String tagName;
    private Map<String, String> attributes = new HashMap<String, String>();

    public Tag() {
    }

    public Tag(Element element) {
        this();
        this.initialize(element);
    }

    private void initialize(Element element) {
        this.attributes.clear();
        for (Attribute a : element.attributes()) {
            this.attributes.put(StringUtils.toLowerCase(a.getKey()), a.getValue());
        }
        this.tagName = StringUtils.toLowerCase(element.nodeName());
    }

    public String getTagName() {
        return this.tagName;
    }

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    public String getAttribute(String name) {
        return name == null ? null : this.attributes.get(name);
    }

    public void setAttribute(String name, String value) {
        if (name != null) {
            if (value == null) {
                this.attributes.remove(name);
            } else {
                this.attributes.put(name, value);
            }
        }
    }

    public String getAttrId() {
        return this.getAttribute("id");
    }

    public void setAttrId(String id) {
        this.setAttribute("id", id);
    }

    public String getAttrClass() {
        return this.getAttribute("class");
    }

    public void setAttrClass(String clazz) {
        this.setAttribute("class", clazz);
    }

    public String toString() {
        return String.format("%s: id=%s", this.getTagName(), this.getAttrId());
    }
}

