/*
 * Decompiled with CFR 0.152.
 */
package org.bacza.data.html;

import java.util.ArrayList;
import java.util.List;
import org.bacza.data.html.FormElement;
import org.bacza.data.html.FormValueOption;
import org.bacza.data.html.Tag;
import org.bacza.utils.StringUtils;
import org.jsoup.nodes.Element;

public class InputTag
extends Tag
implements FormElement {
    public InputTag() {
    }

    public InputTag(Element element) {
        super(element);
    }

    @Override
    public String getName() {
        return this.getAttrName();
    }

    @Override
    public String getType() {
        return String.format("input.%s", StringUtils.nvl(this.getAttrType(), "unknown"));
    }

    @Override
    public boolean isSelectable() {
        return this.isRadioType() || this.isCheckboxType() || this.isSubmitType();
    }

    @Override
    public boolean isMultiSelectable() {
        return this.isCheckboxType();
    }

    @Override
    public String getValue() {
        return this.getAttrValue();
    }

    @Override
    public List<FormValueOption> getOptions() {
        if (this.isSelectable()) {
            ArrayList<FormValueOption> result = new ArrayList<FormValueOption>(1);
            result.add(new FormValueOption(this.getAttrId(), this.getAttrValue(), this.isChecked()));
            return result;
        }
        return null;
    }

    public String getAttrName() {
        return this.getAttribute("name");
    }

    public void setAttrName(String name) {
        this.setAttribute("name", name);
    }

    public String getAttrValue() {
        return this.getAttribute("value");
    }

    public void setAttrValue(String value) {
        this.setAttribute("value", value);
    }

    public String getAttrType() {
        return StringUtils.toLowerCase(this.getAttribute("type"));
    }

    public void setAttrType(String type) {
        this.setAttribute("type", type);
    }

    public boolean isHiddenType() {
        return "hidden".equals(this.getAttrType());
    }

    public boolean isTextType() {
        return "text".equals(this.getAttrType());
    }

    public boolean isPasswordType() {
        return "password".equals(this.getAttrType());
    }

    public boolean isNumberType() {
        return "number".equals(this.getAttrType());
    }

    public boolean isRadioType() {
        return "radio".equals(this.getAttrType());
    }

    public boolean isCheckboxType() {
        return "checkbox".equals(this.getAttrType());
    }

    public boolean isSubmitType() {
        return "submit".equals(this.getAttrType());
    }

    public String getAttrPlaceholder() {
        return this.getAttribute("placeholder");
    }

    public void setAttrPlaceholder(String placeholder) {
        this.setAttribute("placeholder", placeholder);
    }

    public String getAttrMin() {
        return this.getAttribute("min");
    }

    public void setAttrMin(String min) {
        this.setAttribute("min", min);
    }

    public String getAttrMax() {
        return this.getAttribute("max");
    }

    public void setAttrMax(String max) {
        this.setAttribute("max", max);
    }

    public boolean isChecked() {
        return StringUtils.equalsAny(this.getAttribute("checked"), "checked", "");
    }

    public void setChecked(boolean checked) {
        this.setAttribute("checked", checked ? "checked" : null);
    }

    @Override
    public String toString() {
        return String.format("input: t=%s n=%s v=%s i=%s", this.getAttrType(), this.getAttrName(), this.getAttrValue(), this.getAttrId());
    }
}

