/*
 * Decompiled with CFR 0.152.
 */
package org.bacza.data.html;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.bacza.data.html.FormElement;
import org.bacza.data.html.FormValueOption;
import org.bacza.utils.StringUtils;

public class FormValue {
    private String name;
    private String type;
    private String value;
    private boolean selectable;
    private boolean multiSelectable;
    private String defaultSelectedOptionValue;
    private final List<FormValueOption> options = new LinkedList<FormValueOption>();
    private final List<FormValueOption> selectedOptions = new LinkedList<FormValueOption>();
    private final Set<String> optionIds = new HashSet<String>();
    private final Set<String> optionValues = new HashSet<String>();

    public boolean isInitialized() {
        return StringUtils.notEmpty(this.name, this.type);
    }

    public boolean addElement(FormElement element) {
        String elementType;
        String elementName;
        if (element != null && StringUtils.notEmpty(elementName = element.getName(), elementType = element.getType())) {
            if (!this.isInitialized()) {
                this.setName(elementName);
                this.setType(elementType);
                this.setValue(element.getValue());
                this.setSelectable(element.isSelectable());
                this.setMultiSelectable(element.isMultiSelectable());
                this.processOptions(element);
                return true;
            }
            if (elementName.equals(this.getName()) && elementType.equals(this.getType()) && element.isSelectable() && this.isSelectable()) {
                this.processOptions(element);
                return true;
            }
        }
        return false;
    }

    private void processOptions(FormElement element) {
        List<FormValueOption> elementOptions;
        if (element != null && element.isSelectable() && (elementOptions = element.getOptions()) != null) {
            for (FormValueOption elementOption : elementOptions) {
                this.addOption(elementOption);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public void setSelectable(boolean selectable) {
        this.selectable = selectable;
    }

    public boolean isMultiSelectable() {
        return this.multiSelectable;
    }

    public void setMultiSelectable(boolean multiSelectable) {
        this.multiSelectable = multiSelectable;
    }

    public String getValue() {
        return StringUtils.nvl(this.value);
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getDefaultSelectedOptionValue() {
        return StringUtils.nvl(this.defaultSelectedOptionValue);
    }

    public void setDefaultSelectedOptionValue(String defaultSelectedOptionValue) {
        this.defaultSelectedOptionValue = defaultSelectedOptionValue;
    }

    public void addOption(FormValueOption option) {
        if (option != null) {
            this.options.add(option);
            if (option.isSelected()) {
                this.selectedOptions.add(option);
            }
            this.optionIds.add(option.getId());
            this.optionValues.add(option.getValue());
        }
    }

    public void removeOptionById(String id) {
        if (this.containsOptionId(id)) {
            this.visitOptions(new RemovalVisitor(2, id));
        }
    }

    public void removeOptionByValue(String value) {
        if (this.containsOptionValue(value)) {
            this.visitOptions(new RemovalVisitor(3, value));
        }
    }

    public void removeAllOptions() {
        this.options.clear();
        this.selectedOptions.clear();
        this.optionIds.clear();
        this.optionValues.clear();
    }

    public boolean selectOptionById(String id, boolean selected) {
        if (this.containsOptionId(id)) {
            this.visitOptions(new SelectionVisitor(2, id, selected, this.isMultiSelectable()));
            return true;
        }
        return false;
    }

    public boolean selectOptionByValue(String value, boolean selected) {
        if (this.containsOptionValue(value)) {
            this.visitOptions(new SelectionVisitor(3, value, selected, this.isMultiSelectable()));
            return true;
        }
        return false;
    }

    public void selectAllOptions(boolean selected) {
        this.visitOptions(new SelectionVisitor(selected, this.isMultiSelectable()));
    }

    public List<FormValueOption> getOptions() {
        return this.options;
    }

    public List<FormValueOption> getSelectedOptions() {
        return this.selectedOptions;
    }

    public FormValueOption getSelectedOption() {
        return this.selectedOptions != null && this.selectedOptions.size() > 0 ? this.selectedOptions.get(0) : null;
    }

    public List<String> getOptionIds() {
        return new ArrayList<String>(this.optionIds);
    }

    public List<String> getOptionValues() {
        return new ArrayList<String>(this.optionValues);
    }

    public boolean containsOptionId(String id) {
        return this.optionIds.contains(id);
    }

    public boolean containsOptionValue(String value) {
        return this.optionValues.contains(value);
    }

    private void visitOptions(Visitor visitor) {
        if (visitor != null) {
            boolean modified = false;
            this.selectedOptions.clear();
            Iterator<FormValueOption> iter = this.options.iterator();
            while (iter.hasNext()) {
                FormValueOption option = iter.next();
                if (!visitor.visit(option)) {
                    iter.remove();
                    modified = true;
                }
                if (!option.isSelected()) continue;
                this.selectedOptions.add(option);
            }
            if (modified) {
                this.rebuildOptionsCache();
            }
        }
    }

    private void rebuildOptionsCache() {
        this.optionIds.clear();
        this.optionValues.clear();
        this.selectedOptions.clear();
        for (FormValueOption option : this.options) {
            this.optionIds.add(option.getId());
            this.optionValues.add(option.getValue());
            if (!option.isSelected()) continue;
            this.selectedOptions.add(option);
        }
    }

    public String toString() {
        if (this.isSelectable()) {
            return String.format("type=%s, name=%s, options=%d (%s)", this.getType(), this.getName(), this.options.size(), this.isMultiSelectable() ? "multi" : "single");
        }
        return String.format("type=%s, name=%s", this.getType(), this.getName());
    }

    private class RemovalVisitor
    implements Visitor {
        private int searchMode;
        private String searchStr;

        public RemovalVisitor(int searchMode, String searchStr) {
            this.searchMode = searchMode;
            this.searchStr = searchStr;
        }

        @Override
        public boolean visit(FormValueOption option) {
            if (this.searchStr != null) {
                switch (this.searchMode) {
                    case 2: {
                        if (!this.searchStr.equals(option.getId())) break;
                        return false;
                    }
                    case 3: {
                        if (!this.searchStr.equals(option.getValue())) break;
                        return false;
                    }
                }
            }
            return true;
        }
    }

    private class SelectionVisitor
    implements Visitor {
        private int searchMode;
        private String searchStr;
        private boolean selected;
        private boolean multi;

        public SelectionVisitor(boolean selected, boolean multi) {
            this(1, null, selected, multi);
        }

        public SelectionVisitor(int searchMode, String searchStr, boolean selected, boolean multi) {
            this.searchMode = searchMode;
            this.searchStr = searchStr;
            this.selected = selected;
            this.multi = multi;
        }

        @Override
        public boolean visit(FormValueOption option) {
            switch (this.searchMode) {
                case 1: {
                    if (this.selected) {
                        if (!this.multi) break;
                        option.setSelected(true);
                        break;
                    }
                    option.setSelected(false);
                    break;
                }
                case 2: {
                    this.setSelected(option, this.searchStr != null && this.searchStr.equals(option.getId()));
                    break;
                }
                case 3: {
                    this.setSelected(option, this.searchStr != null && this.searchStr.equals(option.getValue()));
                }
            }
            return true;
        }

        private void setSelected(FormValueOption option, boolean found) {
            if (this.selected) {
                if (this.multi) {
                    if (found) {
                        option.setSelected(true);
                    }
                } else {
                    option.setSelected(found);
                }
            } else if (found) {
                option.setSelected(false);
            }
        }
    }

    private static interface Visitor {
        public static final int VISIT_ALL = 1;
        public static final int VISIT_BY_ID = 2;
        public static final int VISIT_BY_VALUE = 3;

        public boolean visit(FormValueOption var1);
    }
}

