/*
 * Decompiled with CFR 0.152.
 */
package org.bacza.data.html;

import geocentral.common.ui.CommonMessages;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bacza.data.html.FormData;
import org.bacza.data.html.FormElement;
import org.bacza.data.html.FormValue;
import org.bacza.data.html.FormValueOption;
import org.bacza.utils.AssertUtils;

public final class FormDataUtils {
    private static final Log log = LogFactory.getLog(FormDataUtils.class);

    public static List<FormValue> getFormValuesMatchingName(FormData form, String regex) {
        AssertUtils.notNull(form);
        LinkedList<FormValue> result = new LinkedList<FormValue>();
        for (FormValue value : form.getValues()) {
            String name = value.getName();
            if (name == null || !name.matches(regex)) continue;
            result.add(value);
        }
        return result;
    }

    public static FormValueOption getFormValueOptionMatchingValue(FormValue value, String regex) {
        AssertUtils.notNull(value);
        for (FormValueOption option : value.getOptions()) {
            String v = option.getValue();
            if (v == null || !v.matches(regex)) continue;
            return option;
        }
        return null;
    }

    public static boolean selectOptionById(FormData form, String valueName, String id, boolean selected) {
        AssertUtils.notNull(form);
        FormValue formValue = form.getValue(valueName);
        AssertUtils.notNull(formValue);
        AssertUtils.checkArgument(formValue.isSelectable(), CommonMessages.MSG_INV_FORM);
        return formValue.selectOptionById(id, selected);
    }

    public static boolean selectOptionByValue(FormData form, String valueName, String value, boolean selected) {
        AssertUtils.notNull(form);
        FormValue formValue = form.getValue(valueName);
        AssertUtils.notNull(formValue);
        AssertUtils.checkArgument(formValue.isSelectable(), CommonMessages.MSG_INV_FORM);
        return formValue.selectOptionByValue(value, selected);
    }

    public static void selectAllOptions(FormData form, String valueName, boolean selected) {
        AssertUtils.notNull(form);
        FormValue value = form.getValue(valueName);
        AssertUtils.notNull(value);
        AssertUtils.checkArgument(value.isSelectable(), CommonMessages.MSG_INV_FORM);
        value.selectAllOptions(selected);
    }

    public static void removeAllOptions(FormData form, String valueName) {
        AssertUtils.notNull(form);
        FormValue value = form.getValue(valueName);
        AssertUtils.notNull(value);
        AssertUtils.checkArgument(value.isSelectable(), CommonMessages.MSG_INV_FORM);
        value.removeAllOptions();
    }

    public static void setValue(FormData form, String valueName, String value) {
        AssertUtils.notNull(form);
        FormValue formValue = form.getValue(valueName);
        AssertUtils.notNull(formValue);
        AssertUtils.checkArgument(!formValue.isSelectable(), CommonMessages.MSG_INV_FORM);
        formValue.setValue(value);
    }

    public static void setDefaultSelectedOptionValue(FormData form, String valueName, String defaultSelectedOptionValue) {
        AssertUtils.notNull(form);
        FormValue formValue = form.getValue(valueName);
        AssertUtils.notNull(formValue);
        AssertUtils.checkArgument(formValue.isSelectable(), CommonMessages.MSG_INV_FORM);
        formValue.setDefaultSelectedOptionValue(defaultSelectedOptionValue);
    }

    public static FormValueOption getSelectedOption(FormData form, String valueName) {
        AssertUtils.notNull(form);
        FormValue formValue = form.getValue(valueName);
        AssertUtils.notNull(formValue);
        AssertUtils.checkArgument(formValue.isSelectable(), CommonMessages.MSG_INV_FORM);
        return formValue.getSelectedOption();
    }

    public static String getSelectedOptionId(FormData form, String valueName) {
        FormValueOption option = FormDataUtils.getSelectedOption(form, valueName);
        return option != null ? option.getId() : null;
    }

    public static String getSelectedOptionValue(FormData form, String valueName) {
        FormValueOption option = FormDataUtils.getSelectedOption(form, valueName);
        return option != null ? option.getValue() : null;
    }

    public static void print(String msg, Object ... args) {
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format(msg, args));
        }
    }

    public static void printFormData(FormData data) {
        if (data != null) {
            FormDataUtils.print("Form: name=%s, action=%s, method=%s", data.getName(), data.getAction(), data.getMethod());
            FormDataUtils.print("Form elements: %d", data.getElementCount());
            for (FormElement input : data.getElements()) {
                FormDataUtils.print("%s", input);
            }
            FormDataUtils.print("Form values: %d", data.getValueCount());
            for (FormValue value : data.getValues()) {
                FormDataUtils.print("%s", value);
            }
            FormDataUtils.print("", new Object[0]);
        }
    }

    public static void printFormValue(FormValue value) {
        if (value != null) {
            if (value.isSelectable()) {
                FormDataUtils.print("Form value: name=%s, type=%s (%s)", value.getName(), value.getName(), value.isMultiSelectable() ? "multi" : "single");
                List<FormValueOption> options = value.getOptions();
                if (options != null) {
                    for (FormValueOption option : options) {
                        FormDataUtils.print("%s", option);
                    }
                }
            } else {
                FormDataUtils.print("Form value: name=%s, type=%s, value=%s", value.getName(), value.getType(), value.getValue());
            }
        }
    }

    public static void dump(FormData form) {
        if (form != null && log.isTraceEnabled()) {
            String str = String.format("Form data dump:%n%s", form.getFormDataAsString());
            log.trace((Object)str);
        }
    }
}

