/*
 * Decompiled with CFR 0.152.
 */
package org.bacza.data.html;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.bacza.data.html.FormData;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class DocumentData {
    private List<FormData> forms = new LinkedList<FormData>();

    public DocumentData() {
    }

    public DocumentData(Element root) {
        this();
        this.initialize(root);
    }

    private void initialize(Element root) {
        if (root != null) {
            Elements elements = root.select("form");
            for (Element element : elements) {
                this.addForm(new FormData(element));
            }
        }
    }

    public void addForm(FormData form) {
        if (form != null) {
            this.forms.add(form);
        }
    }

    public int getFormCount() {
        return this.forms.size();
    }

    public FormData getForm(int index) {
        if (index >= 0 && index < this.forms.size()) {
            return this.forms.get(index);
        }
        return null;
    }

    public FormData getFirstForm() {
        return this.getForm(0);
    }

    public FormData getLastForm() {
        return this.getForm(this.forms.size() - 1);
    }

    public List<FormData> getForms() {
        return this.forms;
    }

    public FormData getMatchingForm(Collection<String> names) {
        if (names != null) {
            for (FormData form : this.forms) {
                if (!form.containsAllValues(names)) continue;
                return form;
            }
        }
        return null;
    }

    public FormData getFormMatchingAction(String regex) {
        if (regex != null) {
            for (FormData form : this.forms) {
                String action = form.getAction();
                if (action == null || !action.matches(regex)) continue;
                return form;
            }
        }
        return null;
    }
}

