/*
 * Decompiled with CFR 0.152.
 */
package org.bacza.data.html;

import java.util.LinkedList;
import java.util.List;
import org.bacza.data.html.InputTag;

public class CompoundInput {
    private List<InputTag> inputs = new LinkedList<InputTag>();

    public boolean hasInputs() {
        return this.inputs.size() > 0;
    }

    public int getSize() {
        return this.inputs.size();
    }

    public List<InputTag> getInputs() {
        return this.inputs;
    }

    public InputTag getFirstInput() {
        if (this.inputs.size() > 0) {
            return this.inputs.get(0);
        }
        return null;
    }

    public String getName() {
        if (this.hasInputs()) {
            return this.getFirstInput().getAttrName();
        }
        return null;
    }

    public String getType() {
        if (this.hasInputs()) {
            return this.getFirstInput().getAttrType();
        }
        return null;
    }

    public String getValue() {
        return null;
    }

    public boolean isRadioType() {
        if (this.hasInputs()) {
            return this.getFirstInput().isRadioType();
        }
        return false;
    }

    public boolean isCheckboxType() {
        if (this.hasInputs()) {
            return this.getFirstInput().isCheckboxType();
        }
        return false;
    }

    public boolean add(InputTag input) {
        if (this.isCompatible(input)) {
            return this.inputs.add(input);
        }
        return false;
    }

    public boolean isCompatible(InputTag input) {
        if (input == null) {
            return false;
        }
        if (this.hasInputs()) {
            return this.getType().equals(input.getAttrType()) && this.getName().equals(input.getAttrName());
        }
        return true;
    }
}

