/*
 * Decompiled with CFR 0.152.
 */
package geocentral.ui.views;

import geocentral.common.Messages;
import geocentral.ui.views.TableColumnConfig;
import java.util.LinkedList;
import java.util.List;
import org.bacza.utils.AssertUtils;
import org.bacza.utils.StringUtils;

public class TableViewConfig {
    private final String id;
    private final String name;
    private final String key;
    private final List<TableColumnConfig> columns;

    public TableViewConfig(String id, String name) {
        AssertUtils.notEmpty(id, "id");
        AssertUtils.notEmpty(name, "name");
        this.id = id;
        this.name = name;
        this.key = String.format("TableViewConfig.%s", id);
        this.columns = new LinkedList<TableColumnConfig>();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return StringUtils.nvl(Messages.getString(this.key), this.name);
    }

    public List<TableColumnConfig> getColumns() {
        return this.columns;
    }

    public TableColumnConfig getColumnByIndex(int index) {
        if (this.columns != null) {
            for (TableColumnConfig column : this.columns) {
                if (column.getIndex() != index) continue;
                return column;
            }
        }
        return null;
    }

    public void addColumn(TableColumnConfig config) {
        if (config != null) {
            this.columns.add(config);
        }
    }

    public String toString() {
        return String.format("%s, %s, %d", this.id, this.name, this.columns.size());
    }
}

