/*
 * Decompiled with CFR 0.152.
 */
package geocentral.http;

import geocentral.common.ui.preferences.PreferenceStoreManager;
import java.io.IOException;
import okhttp3.Authenticator;
import okhttp3.Credentials;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProxyAuthenticator
implements Authenticator {
    private static final Log log = LogFactory.getLog(ProxyAuthenticator.class);

    public Request authenticate(Route route, Response response) throws IOException {
        if (response.request().header("Proxy-Authorization") != null) {
            log.debug((Object)"Proxy authorization failed.");
            return null;
        }
        log.debug((Object)"Attempting proxy authorization...");
        String proxyAuthUser = PreferenceStoreManager.getStore().getString("geocentral.preferences.net.proxy_auth_user");
        String proxyAuthPass = PreferenceStoreManager.getStore().getString("geocentral.preferences.net.proxy_auth_pass");
        String credential = Credentials.basic((String)proxyAuthUser, (String)proxyAuthPass);
        return response.request().newBuilder().header("Proxy-Authorization", credential).build();
    }
}

