/*
 * Decompiled with CFR 0.152.
 */
package geocentral.files.gpx;

import geocentral.common.data.DataReaderContext;
import geocentral.common.data.parsers.DataParserService;
import geocentral.common.data.parsers.IAttributes;
import geocentral.common.data.parsers.UserParser;
import geocentral.common.items.WaypointItem;
import org.bacza.utils.DateUtils;

public class WptParser
extends UserParser {
    private static final DataParserService dataParserService = DataParserService.getInstance();
    private final WaypointItem waypoint = new WaypointItem();

    public WptParser(DataReaderContext readerContext, double lat, double lon) {
        super(readerContext);
        this.waypoint.setLat(lat);
        this.waypoint.setLon(lon);
    }

    @Override
    public void startProcessing() {
        this.readerContext.pushItem(this.waypoint);
    }

    @Override
    public void stopProcessing() {
        this.readerContext.getDataStore().putItem(this.readerContext.popItem());
    }

    @Override
    public void startElement(String name, String namespace, String uri, IAttributes attrs) {
        UserParser parser = dataParserService.getParser(name, uri, this.readerContext);
        if (parser != null) {
            this.installParser(parser);
        }
    }

    @Override
    public void value(String name, Object value, IAttributes attrs) {
        if ("name".equals(name)) {
            this.waypoint.setName(WptParser.getValueAsString(value));
        } else if ("time".equals(name)) {
            this.waypoint.setDate(DateUtils.parseDateIso8601(WptParser.getValueAsString(value)));
        } else if ("desc".equals(name)) {
            this.waypoint.setDescription(WptParser.getValueAsString(value));
        } else if ("type".equals(name)) {
            this.waypoint.setType(WptParser.getValueAsString(value));
        } else if ("sym".equals(name)) {
            this.waypoint.setSymbol(WptParser.getValueAsString(value));
        } else if ("url".equals(name)) {
            this.waypoint.setUrl(WptParser.getValueAsString(value));
        } else if ("urlname".equals(name)) {
            this.waypoint.setUrlname(WptParser.getValueAsString(value));
        } else if ("ele".equals(name)) {
            this.waypoint.setElevation(WptParser.getValueAsString(value));
        }
    }
}

