/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.ws;

import geocentral.common.ws.LoginRequiredException;
import geocentral.common.ws.WsTaskInfo;
import java.io.IOException;
import java.net.URI;
import org.bacza.data.html.DocumentData;
import org.bacza.data.html.LoginAssert;
import org.bacza.http.WebResponse;
import org.bacza.http.WebResponseUtils;
import org.bacza.utils.AssertUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public final class WsUtils {
    public static final DocumentData getDocData(WebResponse response) throws IOException {
        AssertUtils.notNull(response, "Http Response");
        if (WebResponseUtils.isHtmlResponse(response)) {
            URI baseUri = response.getLastURI();
            String html = response.getContentText();
            Document doc = Jsoup.parse((String)html, (String)baseUri.toASCIIString());
            DocumentData data = new DocumentData((Element)doc);
            return data;
        }
        return null;
    }

    public static final DocumentData getDocDataWithLoginCheck(WebResponse response, WsTaskInfo info) throws IOException, LoginRequiredException {
        DocumentData data = WsUtils.getDocData(response);
        if (data != null) {
            LoginAssert.checkPasswordInput(data, info);
        }
        return data;
    }
}

