/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.ui.preferences;

import geocentral.common.Messages;
import org.bacza.utils.StringUtils;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NetworkingPreferencePage
extends PreferencePage {
    private Button btnProxy;
    private Group grpProxy;
    private Text txtProxyAddr;
    private Text txtProxyPort;
    private Button btnAuth;
    private Group grpAuth;
    private Text txtAuthUser;
    private Text txtAuthPass;
    private Group grpTime;
    private Text txtTimeoutConnect;
    private Text txtTimeoutSocket;

    public NetworkingPreferencePage() {
        super(Messages.getString("Preferences.networking.pageName"));
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.btnProxy = new Button(composite, 32);
        this.btnProxy.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnProxy.setText(Messages.getString("Preferences.networking.useProxyServer"));
        this.grpProxy = new Group(composite, 0);
        this.grpProxy.setLayout((Layout)new GridLayout(4, false));
        this.grpProxy.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.grpProxy.setText(Messages.getString("Preferences.networking.proxyServer"));
        Label lblAddress = new Label((Composite)this.grpProxy, 0);
        lblAddress.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblAddress.setText(Messages.getString("Preferences.networking.address"));
        this.txtProxyAddr = new Text((Composite)this.grpProxy, 2048);
        this.txtProxyAddr.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblPort = new Label((Composite)this.grpProxy, 0);
        lblPort.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblPort.setText(Messages.getString("Preferences.networking.port"));
        this.txtProxyPort = new Text((Composite)this.grpProxy, 2048);
        this.txtProxyPort.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                NetworkingPreferencePage.this.verifyNumber(e, 0, 65535);
            }
        });
        GridData gd_txtPort = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_txtPort.widthHint = 60;
        this.txtProxyPort.setLayoutData((Object)gd_txtPort);
        this.txtProxyPort.setTextLimit(5);
        this.btnAuth = new Button((Composite)this.grpProxy, 32);
        this.btnAuth.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 4, 1));
        this.btnAuth.setText(Messages.getString("Preferences.networking.authorizationRequired"));
        this.grpAuth = new Group((Composite)this.grpProxy, 0);
        this.grpAuth.setText(Messages.getString("Preferences.networking.authorization"));
        this.grpAuth.setLayout((Layout)new GridLayout(2, false));
        this.grpAuth.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 4, 1));
        Label lblAuthUser = new Label((Composite)this.grpAuth, 0);
        lblAuthUser.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblAuthUser.setText(Messages.getString("Preferences.networking.user"));
        this.txtAuthUser = new Text((Composite)this.grpAuth, 2048);
        this.txtAuthUser.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblAuthPass = new Label((Composite)this.grpAuth, 0);
        lblAuthPass.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblAuthPass.setText(Messages.getString("Preferences.networking.password"));
        this.txtAuthPass = new Text((Composite)this.grpAuth, 0x400800);
        this.txtAuthPass.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnProxy.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                NetworkingPreferencePage.this.enableControls();
            }
        });
        this.btnAuth.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                NetworkingPreferencePage.this.enableControls();
            }
        });
        this.grpTime = new Group(composite, 0);
        this.grpTime.setText(Messages.getString("Preferences.networking.timeouts"));
        this.grpTime.setLayout((Layout)new GridLayout(2, false));
        this.grpTime.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 4, 1));
        Label lblTimeoutConnect = new Label((Composite)this.grpTime, 0);
        lblTimeoutConnect.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblTimeoutConnect.setText(Messages.getString("Preferences.networking.openingConnection"));
        this.txtTimeoutConnect = new Text((Composite)this.grpTime, 2048);
        this.txtTimeoutConnect.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                NetworkingPreferencePage.this.verifyNumber(e, 0, 999);
            }
        });
        this.txtTimeoutConnect.setTextLimit(3);
        this.txtTimeoutConnect.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblTimeoutSocket = new Label((Composite)this.grpTime, 0);
        lblTimeoutSocket.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblTimeoutSocket.setText(Messages.getString("Preferences.networking.waitingForData"));
        this.txtTimeoutSocket = new Text((Composite)this.grpTime, 2048);
        this.txtTimeoutSocket.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                NetworkingPreferencePage.this.verifyNumber(e, 0, 999);
            }
        });
        this.txtTimeoutSocket.setTextLimit(3);
        this.txtTimeoutSocket.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.initControls();
        return composite;
    }

    private void verifyNumber(VerifyEvent e, int min, int max) {
        block3: {
            String currentText = ((Text)e.widget).getText();
            String port = String.valueOf(currentText.substring(0, e.start)) + e.text + currentText.substring(e.end);
            try {
                int portNum = Integer.valueOf(port);
                if (portNum < min || portNum > max) {
                    e.doit = false;
                }
            }
            catch (NumberFormatException ex) {
                if (port.equals("")) break block3;
                e.doit = false;
            }
        }
    }

    private void initControls() {
        IPreferenceStore store = this.getPreferenceStore();
        this.btnProxy.setSelection(store.getBoolean("geocentral.preferences.net.use_proxy"));
        this.txtProxyAddr.setText(StringUtils.nvl(store.getString("geocentral.preferences.net.proxy_addr")));
        this.txtProxyPort.setText(StringUtils.nvl(store.getString("geocentral.preferences.net.proxy_port")));
        this.btnAuth.setSelection(store.getBoolean("geocentral.preferences.net.use_proxy_auth"));
        this.txtAuthUser.setText(StringUtils.nvl(store.getString("geocentral.preferences.net.proxy_auth_user")));
        this.txtAuthPass.setText(StringUtils.nvl(store.getString("geocentral.preferences.net.proxy_auth_pass")));
        this.txtTimeoutConnect.setText(StringUtils.nvl(store.getString("geocentral.preferences.net.connect_timeout")));
        this.txtTimeoutSocket.setText(StringUtils.nvl(store.getString("geocentral.preferences.net.socket_timeout")));
        this.enableControls();
    }

    private void enableControls() {
        this.enableProxyControls();
        this.enableAuthControls();
    }

    private void enableProxyControls() {
        this.recursiveSetEnabled((Control)this.grpProxy, this.btnProxy.getSelection());
    }

    private void enableAuthControls() {
        this.recursiveSetEnabled((Control)this.grpAuth, this.btnProxy.getSelection() && this.btnAuth.getSelection());
    }

    private void recursiveSetEnabled(Control ctrl, boolean enabled) {
        if (ctrl instanceof Composite) {
            Composite comp = (Composite)ctrl;
            Control[] controlArray = comp.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                this.recursiveSetEnabled(c, enabled);
                ++n2;
            }
            ctrl.setEnabled(enabled);
        } else {
            ctrl.setEnabled(enabled);
        }
    }

    protected void performDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        this.btnProxy.setSelection(store.getDefaultBoolean("geocentral.preferences.net.use_proxy"));
        this.txtProxyAddr.setText(StringUtils.nvl(store.getDefaultString("geocentral.preferences.net.proxy_addr")));
        this.txtProxyPort.setText(StringUtils.nvl(store.getDefaultString("geocentral.preferences.net.proxy_port")));
        this.btnAuth.setSelection(store.getDefaultBoolean("geocentral.preferences.net.use_proxy_auth"));
        this.txtAuthUser.setText(StringUtils.nvl(store.getDefaultString("geocentral.preferences.net.proxy_auth_user")));
        this.txtAuthPass.setText(StringUtils.nvl(store.getDefaultString("geocentral.preferences.net.proxy_auth_pass")));
        this.txtTimeoutConnect.setText(StringUtils.nvl(store.getDefaultString("geocentral.preferences.net.connect_timeout")));
        this.txtTimeoutSocket.setText(StringUtils.nvl(store.getDefaultString("geocentral.preferences.net.socket_timeout")));
        this.enableControls();
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        if (this.btnProxy != null) {
            store.setValue("geocentral.preferences.net.use_proxy", this.btnProxy.getSelection());
        }
        if (this.txtProxyAddr != null) {
            store.setValue("geocentral.preferences.net.proxy_addr", this.txtProxyAddr.getText());
        }
        if (this.txtProxyPort != null) {
            store.setValue("geocentral.preferences.net.proxy_port", this.txtProxyPort.getText());
        }
        if (this.btnAuth != null) {
            store.setValue("geocentral.preferences.net.use_proxy_auth", this.btnAuth.getSelection());
        }
        if (this.txtAuthUser != null) {
            store.setValue("geocentral.preferences.net.proxy_auth_user", this.txtAuthUser.getText());
        }
        if (this.txtAuthPass != null) {
            store.setValue("geocentral.preferences.net.proxy_auth_pass", this.txtAuthPass.getText());
        }
        if (this.txtTimeoutConnect != null) {
            store.setValue("geocentral.preferences.net.connect_timeout", this.txtTimeoutConnect.getText());
        }
        if (this.txtTimeoutSocket != null) {
            store.setValue("geocentral.preferences.net.socket_timeout", this.txtTimeoutSocket.getText());
        }
        return true;
    }

    public static void setDefaults(PreferenceStore store) {
        store.setDefault("geocentral.preferences.net.use_proxy", false);
        store.setDefault("geocentral.preferences.net.proxy_addr", "");
        store.setDefault("geocentral.preferences.net.proxy_port", "");
        store.setDefault("geocentral.preferences.net.use_proxy_auth", false);
        store.setDefault("geocentral.preferences.net.proxy_auth_user", "");
        store.setDefault("geocentral.preferences.net.proxy_auth_pass", "");
        store.setDefault("geocentral.preferences.net.connect_timeout", "30");
        store.setDefault("geocentral.preferences.net.socket_timeout", "90");
    }
}

