/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.ui.dialogs;

import geocentral.common.Messages;
import geocentral.common.geocaching.GeocacheSite;
import geocentral.common.geocaching.SiteImageProviderService;
import geocentral.common.ui.dialogs.SiteLoginDialog;
import geocentral.common.ui.dialogs.WidgetSizeUtils;
import geocentral.common.ws.LoginAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class OAuthLoginDialog
extends SiteLoginDialog {
    private GeocacheSite site;
    private LoginAction loginAction;

    public OAuthLoginDialog(Shell parentShell, GeocacheSite site, LoginAction loginAction) {
        super(parentShell);
        this.site = site;
        this.loginAction = loginAction;
    }

    @Override
    protected Control createPageControls(Composite parent) {
        this.setTitle(String.format(Messages.getString("OAuthLoginDialog.title"), this.site.getSiteName()));
        this.setMessage(Messages.getString("OAuthLoginDialog.message"));
        Image logo = SiteImageProviderService.getInstance().getSiteLogo(this.site);
        if (logo != null) {
            this.setTitleImage(logo);
        }
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        Label info1 = new Label(container, 64);
        info1.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        info1.setText(String.format(Messages.getString("OAuthLoginDialog.info1"), this.site.getSiteName()));
        Label info2 = new Label(container, 64);
        info2.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        info2.setText(String.format(Messages.getString("OAuthLoginDialog.info2"), "GeoCentral Lite"));
        return container;
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        Point result = WidgetSizeUtils.initialSize(this.getParentShell(), 62, 18);
        if (result == null) {
            result = super.getInitialSize();
        }
        return result;
    }

    @Override
    public GeocacheSite getSite() {
        return this.site;
    }

    @Override
    protected LoginAction getLoginAction() {
        return this.loginAction;
    }

    @Override
    protected void loginPrepare(LoginAction action) {
    }

    @Override
    protected void loginSuccess() {
    }

    @Override
    protected void loginFailed() {
    }

    @Override
    protected void loginCancelled() {
    }
}

