/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.ui.dialogs;

import geocentral.common.Messages;
import geocentral.common.ui.dialogs.WidgetSizeUtils;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class EditLogDateDialog
extends TitleAreaDialog {
    private DateTime dtDate;
    private DateTime dtTime;
    private Button btnDateOnly;
    private Date logDate;
    private boolean dateOnly;

    public Date getLogDate() {
        return this.logDate;
    }

    public void setLogDate(Date logDate) {
        this.logDate = logDate;
    }

    public boolean getDateOnly() {
        return this.dateOnly;
    }

    public void setDateOnly(boolean dateOnly) {
        this.dateOnly = dateOnly;
    }

    public EditLogDateDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(67680);
    }

    protected Control createDialogArea(Composite parent) {
        this.setMessage(Messages.getString("EditLogDateDialog.message"));
        this.setTitle(Messages.getString("EditLogDateDialog.title"));
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        GridData gd_container = new GridData(1808);
        gd_container.verticalAlignment = 0x1000000;
        gd_container.horizontalAlignment = 0x1000000;
        container.setLayoutData((Object)gd_container);
        Label lblNewLabel = new Label(container, 0);
        lblNewLabel.setText(Messages.getString("EditLogDateDialog.dateAndHour"));
        this.dtDate = new DateTime(container, 2084);
        this.dtTime = new DateTime(container, 34944);
        new Label(container, 0);
        this.btnDateOnly = new Button(container, 32);
        this.btnDateOnly.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                EditLogDateDialog.this.dtTime.setEnabled(!EditLogDateDialog.this.btnDateOnly.getSelection());
            }
        });
        this.btnDateOnly.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.btnDateOnly.setText(Messages.getString("EditLogDateDialog.dontChangeTheHour"));
        this.initControls();
        return area;
    }

    private void initControls() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.logDate != null ? this.logDate : new Date());
        this.dtDate.setDate(cal.get(1), cal.get(2), cal.get(5));
        this.dtDate.setTime(0, 0, 0);
        this.dtTime.setDate(cal.get(1), cal.get(2), cal.get(5));
        this.dtTime.setTime(cal.get(11), cal.get(12), cal.get(13));
        this.btnDateOnly.setSelection(this.getDateOnly());
        this.dtTime.setEnabled(!this.btnDateOnly.getSelection());
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        Point result = WidgetSizeUtils.initialSize(this.getParentShell(), 50, 15);
        if (result != null) {
            Point def = WidgetSizeUtils.defaultSize(this.getContents());
            WidgetSizeUtils.extendSize(def, 64, 64);
            return WidgetSizeUtils.maxSize(result, def);
        }
        return super.getInitialSize();
    }

    protected void okPressed() {
        this.saveInput();
        super.okPressed();
    }

    private void saveInput() {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(this.dtDate.getYear(), this.dtDate.getMonth(), this.dtDate.getDay(), this.dtTime.getHours(), this.dtTime.getMinutes(), 0);
        this.setLogDate(cal.getTime());
        this.setDateOnly(this.btnDateOnly.getSelection());
    }
}

