/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.ui;

import geocentral.common.ui.DisplayUtils;
import org.eclipse.core.runtime.IProgressMonitor;

public class ThreadSafeProgressMonitor
implements IProgressMonitor {
    private final IProgressMonitor monitor;

    public ThreadSafeProgressMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public void beginTask(final String name, final int totalWork) {
        DisplayUtils.asyncExec(new Runnable(){

            @Override
            public void run() {
                ThreadSafeProgressMonitor.this.monitor.beginTask(name, totalWork);
            }
        });
    }

    public void done() {
        DisplayUtils.asyncExec(new Runnable(){

            @Override
            public void run() {
                ThreadSafeProgressMonitor.this.monitor.done();
            }
        });
    }

    public void internalWorked(final double work) {
        DisplayUtils.asyncExec(new Runnable(){

            @Override
            public void run() {
                ThreadSafeProgressMonitor.this.monitor.internalWorked(work);
            }
        });
    }

    public boolean isCanceled() {
        final BoleanValue result = new BoleanValue();
        DisplayUtils.syncExec(new Runnable(){

            @Override
            public void run() {
                result.value = ThreadSafeProgressMonitor.this.monitor.isCanceled();
            }
        });
        return result.value;
    }

    public void setCanceled(final boolean value) {
        DisplayUtils.asyncExec(new Runnable(){

            @Override
            public void run() {
                ThreadSafeProgressMonitor.this.monitor.setCanceled(value);
            }
        });
    }

    public void setTaskName(final String name) {
        DisplayUtils.asyncExec(new Runnable(){

            @Override
            public void run() {
                ThreadSafeProgressMonitor.this.monitor.setTaskName(name);
            }
        });
    }

    public void subTask(final String name) {
        DisplayUtils.asyncExec(new Runnable(){

            @Override
            public void run() {
                ThreadSafeProgressMonitor.this.monitor.subTask(name);
            }
        });
    }

    public void worked(final int work) {
        DisplayUtils.asyncExec(new Runnable(){

            @Override
            public void run() {
                ThreadSafeProgressMonitor.this.monitor.worked(work);
            }
        });
    }

    private class BoleanValue {
        private boolean value;

        private BoleanValue() {
        }
    }
}

