/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.ui;

import geocentral.common.app.ConfigManager;
import geocentral.common.scripting.ScriptingManager;
import geocentral.common.ui.ITableViewConfigProvider;
import geocentral.ui.views.IConfigurableTableView;
import geocentral.ui.views.TableViewConfig;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bacza.utils.AssertUtils;
import org.eclipse.jface.action.Action;

public abstract class TableViewConfigActions {
    private static final Log log = LogFactory.getLog(TableViewConfigActions.class);
    private final IConfigurableTableView view;
    private final String docTypeId;
    private boolean reload;
    private final Map<String, TableViewConfig> configMap;
    private final List<TableViewConfig> configList;
    private final List<Action> actions;
    private String currentId;

    public TableViewConfigActions(IConfigurableTableView view, String docTypeId) {
        AssertUtils.notNull(view, "view");
        AssertUtils.notNull(docTypeId, "docTypeId");
        this.view = view;
        this.docTypeId = docTypeId;
        this.reload = true;
        this.configMap = new HashMap<String, TableViewConfig>();
        this.configList = new LinkedList<TableViewConfig>();
        this.actions = new LinkedList<Action>();
        this.setCurrentId(this.getDefaultId());
    }

    public abstract String getDefaultId();

    public synchronized String getCurrentId() {
        return this.currentId;
    }

    public synchronized void setCurrentId(String currentId) {
        this.currentId = currentId;
        if (!this.configMap.containsKey(currentId)) {
            this.reload = true;
        }
    }

    public synchronized TableViewConfig getCurrentConfig() {
        this.checkReload();
        TableViewConfig result = this.configMap.get(this.currentId);
        if (result == null && (result = this.configMap.get(this.getDefaultId())) != null) {
            this.setCurrentId(result.getId());
        }
        if (result == null && this.configList != null && this.configList.size() > 0 && (result = this.configList.get(0)) != null) {
            this.setCurrentId(result.getId());
        }
        return result;
    }

    public synchronized List<Action> getActions() {
        this.checkReload();
        return this.actions;
    }

    public synchronized void reload() {
        this.reload = true;
    }

    protected void checkReload() {
        if (this.reload) {
            this.reload = false;
            this.reloadConfigs();
            this.recreateActions();
        }
    }

    protected void reloadConfigs() {
        this.configMap.clear();
        this.configList.clear();
        List<TableViewConfig> configs = this.getConfigs();
        for (TableViewConfig config : configs) {
            if (config == null) continue;
            String id = config.getId();
            if (this.configMap.containsKey(id)) {
                log.debug((Object)String.format("Duplicated config id: %s", id));
                continue;
            }
            this.configMap.put(id, config);
            this.configList.add(config);
        }
    }

    protected List<TableViewConfig> getConfigs() {
        List<TableViewConfig> dynamicConfigs;
        LinkedList<TableViewConfig> result = new LinkedList<TableViewConfig>();
        List<TableViewConfig> staticConfigs = this.getStaticConfigs();
        if (staticConfigs != null) {
            result.addAll(staticConfigs);
        }
        if ((dynamicConfigs = this.getDynamicConfigs()) != null) {
            result.addAll(dynamicConfigs);
        }
        return result;
    }

    protected abstract List<TableViewConfig> getStaticConfigs();

    protected List<TableViewConfig> getDynamicConfigs() {
        LinkedList<TableViewConfig> result = new LinkedList<TableViewConfig>();
        String scriptId = "geocentral.scripting.menu.view";
        ITableViewConfigProvider provider = ScriptingManager.getInstance().getInterface("geocentral.scripting.menu.view", ITableViewConfigProvider.class);
        if (provider != null) {
            try {
                List<TableViewConfig> configs = provider.getTableViewConfig(this.docTypeId);
                if (configs != null) {
                    for (TableViewConfig config : configs) {
                        if (config == null) continue;
                        result.add(config);
                    }
                }
            }
            catch (Exception e) {
                log.debug((Object)String.format("Exception executing script: %s", "geocentral.scripting.menu.view"), (Throwable)e);
            }
        }
        return result;
    }

    protected void recreateActions() {
        this.actions.clear();
        for (TableViewConfig config : this.configList) {
            Action action = this.createAction(config);
            boolean checked = this.currentId != null && this.currentId.equals(config.getId());
            action.setChecked(checked);
            this.actions.add(action);
        }
    }

    protected Action createAction(final TableViewConfig config) {
        Action action = new Action(config.getName(), 8){

            public void run() {
                TableViewConfigActions.this.view.changeTableColumns(config);
                TableViewConfigActions.this.setCurrentId(config.getId());
                ConfigManager.getInstance().setString("geocentral.fieldnotes.menu.view.configId", config.getId());
            }
        };
        action.setId(config.getId());
        return action;
    }
}

