/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.ui;

import geocentral.api.groundspeak.InvalidLogTypeException;
import geocentral.common.Messages;
import geocentral.common.geocaching.api.PostLogException;
import geocentral.common.ui.DialogUtils;
import geocentral.common.ws.LoginRequiredException;
import java.io.IOException;
import javax.net.ssl.SSLException;
import org.bacza.data.parsers.ParseException;
import org.bacza.http.HttpResponseException;
import org.bacza.utils.StringUtils;

public final class MessageUtils {
    private static String getDefaultMessage() {
        return Messages.getString("MessageUtils.defaultErrorMessage");
    }

    public static String getMessage(Throwable e) {
        return StringUtils.nvl(e.getMessage(), MessageUtils.getDefaultMessage());
    }

    public static void showLoginRequiredError(LoginRequiredException e) {
        DialogUtils.showError(Messages.getString("MessageUtils.unauthorized.title"), String.format("%s:%n%s", Messages.getString("MessageUtils.unauthorized.message"), MessageUtils.getMessage(e)));
    }

    public static void showLoginError(LoginRequiredException e) {
        DialogUtils.showError(Messages.getString("MessageUtils.loginError"), StringUtils.nvl(e.getInfo().getDetails(), MessageUtils.getDefaultMessage()));
    }

    public static void showRecapNotSupportedError() {
        DialogUtils.showError(Messages.getString("MessageUtils.loginError"), Messages.getString("MessageUtils.waitBeforeNextTry"));
    }

    public static void showLoginOK() {
        DialogUtils.showInfo(Messages.getString("MessageUtils.loginOK"));
    }

    public static void showLogoutOK() {
        DialogUtils.showInfo(Messages.getString("MessageUtils.logoutOK"));
    }

    public static void showException(Exception e) {
        DialogUtils.showError(MessageUtils.getMessage(e));
    }

    public static void showException(RuntimeException e) {
        DialogUtils.showError(Messages.getString("MessageUtils.executionError"), MessageUtils.getMessage(e));
    }

    public static void showIOException(IOException e) {
        if (e instanceof HttpResponseException) {
            MessageUtils.showIOException((HttpResponseException)e);
            return;
        }
        if (e instanceof SSLException) {
            MessageUtils.showIOException((SSLException)e);
            return;
        }
        DialogUtils.showError(Messages.getString("MessageUtils.ioError"), MessageUtils.getMessage(e));
    }

    public static void showIOException(HttpResponseException e) {
        DialogUtils.showError(Messages.getString("MessageUtils.httpError"), StringUtils.nvl(e.getDetails(), MessageUtils.getMessage(e)));
    }

    public static void showIOException(SSLException e) {
        DialogUtils.showError(Messages.getString("MessageUtils.sslError"), MessageUtils.getMessage(e));
    }

    public static void showParseException(ParseException e) {
        DialogUtils.showError(Messages.getString("MessageUtils.parseError"), String.format("%s: %s", Messages.getString("MessageUtils.unexpectedResponse"), MessageUtils.getMessage(e)));
    }

    public static void showInvalidLogTypeException(InvalidLogTypeException e) {
        DialogUtils.showError(MessageUtils.getMessage(e));
    }

    public static void showPostLogException(PostLogException e) {
        DialogUtils.showError("Post log error", MessageUtils.getMessage(e));
    }
}

