/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.ui;

import geocentral.common.ui.DialogUtils;
import geocentral.common.ui.DisplayUtils;
import java.io.File;
import org.bacza.utils.AssertUtils;
import org.bacza.utils.FileUtils;
import org.bacza.utils.StringUtils;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public final class FileDialogUtils {
    public static String[] getFiles(Shell shell, int style, String[] names, String[] exts, String path) {
        String[] files;
        AssertUtils.notNull(names, "File descriptions array");
        AssertUtils.notNull(exts, "File extensions array");
        String[] filters = new String[exts.length];
        int i = 0;
        while (i < exts.length) {
            if (!StringUtils.startsWith(exts[i], ".")) {
                throw new IllegalArgumentException("Invalid file extension.");
            }
            filters[i] = "*" + exts[i];
            ++i;
        }
        FileDialog dlg = new FileDialog(shell, style);
        dlg.setFilterNames(names);
        dlg.setFilterExtensions(filters);
        dlg.setFilterPath(path);
        if (dlg.open() != null && (files = dlg.getFileNames()) != null && files.length > 0) {
            String filterPath = dlg.getFilterPath();
            String[] filenames = new String[files.length];
            int filterIndex = dlg.getFilterIndex();
            String filterExt = null;
            if (filterIndex >= 0 && filterIndex < exts.length) {
                filterExt = exts[filterIndex];
            }
            int i2 = 0;
            while (i2 < files.length) {
                String file = files[i2];
                if (StringUtils.notEmpty(filterExt) && !StringUtils.endsWith(file, filterExt)) {
                    file = String.valueOf(file) + filterExt;
                }
                filenames[i2] = String.valueOf(filterPath) + File.separatorChar + file;
                ++i2;
            }
            return filenames;
        }
        return null;
    }

    public static String getFile(Shell shell, int style, String[] names, String[] exts, String path) {
        String[] filenames = FileDialogUtils.getFiles(shell, style, names, exts, path);
        if (filenames != null && filenames.length > 0) {
            return filenames[0];
        }
        return null;
    }

    public static String getFilenameToSave() {
        String filename;
        String msg;
        int style = 8192;
        String[] names = new String[]{"Baza danych GeoCentral (*.db)"};
        String[] exts = new String[]{".db"};
        do {
            if ((filename = FileDialogUtils.getFile(DisplayUtils.getShell(), 8192, names, exts, null)) == null) {
                return null;
            }
            if (FileUtils.fileExists(filename)) continue;
            return filename;
        } while (!DialogUtils.showConfirm(msg = String.format("Czy zast\u0105pi\u0107 istniej\u0105cy plik '%s' ?", filename)));
        return filename;
    }

    public static String[] getFilenamesToOpen() {
        int style = 4098;
        String[] names = new String[]{"Baza danych GeoCentral (*.db)"};
        String[] exts = new String[]{".db"};
        return FileDialogUtils.getFiles(DisplayUtils.getShell(), 4098, names, exts, null);
    }
}

