/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.ui;

import geocentral.common.ui.CustomTextTransfer;
import geocentral.common.ui.DisplayUtils;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;

public final class ClipboardService {
    private static final ClipboardService instance = new ClipboardService();
    private final Clipboard cb = new Clipboard(DisplayUtils.getDisplay());

    public static ClipboardService getInstance() {
        return instance;
    }

    private ClipboardService() {
    }

    public void setContent(String text) {
        if (text != null) {
            TextTransfer transfer = TextTransfer.getInstance();
            Object[] data = new Object[]{text};
            Transfer[] transfers = new Transfer[]{transfer};
            this.cb.setContents(data, transfers);
        }
    }

    public void setContent(String text, String custom) {
        if (text != null && custom != null) {
            TextTransfer textTransfer = TextTransfer.getInstance();
            CustomTextTransfer customTransfer = CustomTextTransfer.getInstance();
            Object[] data = new Object[]{text, custom};
            Transfer[] transfers = new Transfer[]{textTransfer, customTransfer};
            this.cb.setContents(data, transfers);
        }
    }

    public boolean hasContent(Transfer transfer) {
        if (transfer != null) {
            TransferData[] available = this.cb.getAvailableTypes();
            int i = 0;
            while (i < available.length) {
                if (transfer.isSupportedType(available[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean hasTextContent() {
        return this.hasContent((Transfer)TextTransfer.getInstance());
    }

    public boolean hasCustomContent() {
        return this.hasContent((Transfer)CustomTextTransfer.getInstance());
    }

    public String getTextContent() {
        return (String)this.cb.getContents((Transfer)TextTransfer.getInstance());
    }

    public String getCustomContent() {
        return (String)this.cb.getContents((Transfer)CustomTextTransfer.getInstance());
    }
}

