/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.sys;

import geocentral.common.sys.SysDocMetaDAO;
import geocentral.common.sys.SysDocMetaItem;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.bacza.utils.AssertUtils;

public final class SysDocMetaUtils {
    public static List<SysDocMetaItem> select(Connection conn) {
        return SysDocMetaUtils.select(SysDocMetaUtils.createDAO(conn));
    }

    public static SysDocMetaItem selectFirst(Connection conn) {
        return SysDocMetaUtils.selectFirst(SysDocMetaUtils.createDAO(conn));
    }

    public static List<SysDocMetaItem> select(SysDocMetaDAO dao) {
        AssertUtils.notNull(dao, "DAO");
        return SysDocMetaUtils.selectImpl(dao);
    }

    public static SysDocMetaItem selectFirst(SysDocMetaDAO dao) {
        AssertUtils.notNull(dao, "DAO");
        List<SysDocMetaItem> items = SysDocMetaUtils.selectImpl(dao);
        if (items != null && items.size() > 0) {
            return items.get(0);
        }
        return null;
    }

    public static void init(Connection conn, SysDocMetaItem meta) throws SQLException {
        SysDocMetaDAO dao = SysDocMetaUtils.createDAO(conn);
        dao.dropSchema();
        dao.createSchema();
        dao.insert(meta);
    }

    public static void init(Connection conn, String docTypeId, String docTypeVer) throws SQLException {
        SysDocMetaItem meta = new SysDocMetaItem();
        Date now = new Date();
        meta.setId(1);
        meta.setDocTypeId(docTypeId);
        meta.setDocTypeVer(docTypeVer);
        meta.setCreateDate(now);
        meta.setEnterDate(now);
        SysDocMetaUtils.init(conn, meta);
    }

    protected static SysDocMetaDAO createDAO(Connection conn) {
        AssertUtils.notNull(conn, "Connection");
        return new SysDocMetaDAO(conn);
    }

    protected static List<SysDocMetaItem> selectImpl(SysDocMetaDAO dao) {
        try {
            return dao.select();
        }
        catch (SQLException e) {
            return null;
        }
    }
}

