/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.stats;

import geocentral.common.data.FieldNoteItem;
import geocentral.common.geocaching.GeocacheLogToken;
import geocentral.common.geocaching.GeocacheLogType;
import geocentral.common.geocaching.GeocacheLogTypeUtils;
import geocentral.common.geocaching.GeocacheType;
import geocentral.common.stats.GeocacheLogTypeCounter;
import geocentral.common.stats.GeocacheLogTypeDailyCounter;
import geocentral.common.stats.GeocacheTypeCounter;
import geocentral.common.stats.TaggedGeocacheLogTypeCounter;
import geocentral.common.stats.TaggedGeocacheLogTypeDailyCounter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bacza.utils.AssertUtils;

public class GeocacheStatsManager {
    public static final String TOK_TOTAL_FINDS = "$total.finds";
    public static final String TOK_TOTAL_FINDS_TRADI = "$total.finds.tradi";
    public static final String TOK_TOTAL_FINDS_MULTI = "$total.finds.multi";
    public static final String TOK_TOTAL_FINDS_VIRTUAL = "$total.finds.virtual";
    public static final String TOK_TOTAL_FINDS_LETTER = "$total.finds.letter";
    public static final String TOK_TOTAL_FINDS_EVENT = "$total.finds.event";
    public static final String TOK_TOTAL_FINDS_CITO = "$total.finds.cito";
    public static final String TOK_TOTAL_FINDS_MEGA = "$total.finds.mega";
    public static final String TOK_TOTAL_FINDS_GIGA = "$total.finds.giga";
    public static final String TOK_TOTAL_FINDS_MYSTERY = "$total.finds.mystery";
    public static final String TOK_TOTAL_FINDS_WEBCAM = "$total.finds.webcam";
    public static final String TOK_TOTAL_FINDS_EARTH = "$total.finds.earth";
    public static final String TOK_TOTAL_FINDS_GPS = "$total.finds.gps";
    public static final String TOK_TOTAL_FINDS_WIGO = "$total.finds.wigo";
    public static final String TOK_TOTAL_FINDS_LAB = "$total.finds.lab";
    public static final String TOK_FILE_COUNT = "$file.count";
    public static final String TOK_FILE_COUNT_FINDS = "$file.count.finds";
    public static final String TOK_FILE_COUNT_DNFS = "$file.count.dnfs";
    public static final String TOK_DAY_COUNT = "$day.count";
    public static final String TOK_DAY_COUNT_FINDS = "$day.count.finds";
    public static final String TOK_DAY_COUNT_DNFS = "$day.count.dnfs";
    public static final String TOK_FILE_INDEX = "$file.index";
    public static final String TOK_FILE_INDEX_FINDS = "$file.index.finds";
    public static final String TOK_FILE_INDEX_DNFS = "$file.index.dnfs";
    public static final String TOK_DAY_INDEX = "$day.index";
    public static final String TOK_DAY_INDEX_FINDS = "$day.index.finds";
    public static final String TOK_DAY_INDEX_DNFS = "$day.index.dnfs";
    public static final Set<String> TOTAL_TOKENS = new HashSet<String>();
    public static final Set<String> ALL_TOKENS = new HashSet<String>();
    private GeocacheTypeCounter totalStats;
    private final TaggedGeocacheLogTypeCounter fileLogTypeCounter;
    private final TaggedGeocacheLogTypeDailyCounter dayLogTypeCounter;
    private final TaggedGeocacheLogTypeCounter fileLogTypeIndex;
    private final TaggedGeocacheLogTypeDailyCounter dayLogTypeIndex;

    static {
        TOTAL_TOKENS.add(TOK_TOTAL_FINDS);
        TOTAL_TOKENS.add(TOK_TOTAL_FINDS_TRADI);
        TOTAL_TOKENS.add(TOK_TOTAL_FINDS_MULTI);
        TOTAL_TOKENS.add(TOK_TOTAL_FINDS_VIRTUAL);
        TOTAL_TOKENS.add(TOK_TOTAL_FINDS_LETTER);
        TOTAL_TOKENS.add(TOK_TOTAL_FINDS_EVENT);
        TOTAL_TOKENS.add(TOK_TOTAL_FINDS_CITO);
        TOTAL_TOKENS.add(TOK_TOTAL_FINDS_MEGA);
        TOTAL_TOKENS.add(TOK_TOTAL_FINDS_GIGA);
        TOTAL_TOKENS.add(TOK_TOTAL_FINDS_MYSTERY);
        TOTAL_TOKENS.add(TOK_TOTAL_FINDS_WEBCAM);
        TOTAL_TOKENS.add(TOK_TOTAL_FINDS_EARTH);
        TOTAL_TOKENS.add(TOK_TOTAL_FINDS_GPS);
        TOTAL_TOKENS.add(TOK_TOTAL_FINDS_WIGO);
        TOTAL_TOKENS.add(TOK_TOTAL_FINDS_LAB);
        ALL_TOKENS.addAll(TOTAL_TOKENS);
        ALL_TOKENS.add(TOK_FILE_COUNT);
        ALL_TOKENS.add(TOK_FILE_COUNT_FINDS);
        ALL_TOKENS.add(TOK_FILE_COUNT_DNFS);
        ALL_TOKENS.add(TOK_DAY_COUNT);
        ALL_TOKENS.add(TOK_DAY_COUNT_FINDS);
        ALL_TOKENS.add(TOK_DAY_COUNT_DNFS);
        ALL_TOKENS.add(TOK_FILE_INDEX);
        ALL_TOKENS.add(TOK_FILE_INDEX_FINDS);
        ALL_TOKENS.add(TOK_FILE_INDEX_DNFS);
        ALL_TOKENS.add(TOK_DAY_INDEX);
        ALL_TOKENS.add(TOK_DAY_INDEX_FINDS);
        ALL_TOKENS.add(TOK_DAY_INDEX_DNFS);
    }

    public static boolean isTotalStatToken(String token) {
        if (token != null) {
            return TOTAL_TOKENS.contains(token);
        }
        return false;
    }

    public GeocacheStatsManager(List<FieldNoteItem> items) {
        AssertUtils.notNull(items, "Items");
        this.totalStats = new GeocacheTypeCounter();
        this.fileLogTypeCounter = new TaggedGeocacheLogTypeCounter();
        this.dayLogTypeCounter = new TaggedGeocacheLogTypeDailyCounter();
        this.fileLogTypeIndex = new TaggedGeocacheLogTypeCounter();
        this.dayLogTypeIndex = new TaggedGeocacheLogTypeDailyCounter();
        this.init(items);
    }

    protected void init(List<FieldNoteItem> items) {
        for (FieldNoteItem item : items) {
            this.fileLogTypeCounter.add(item);
            this.dayLogTypeCounter.add(item);
        }
    }

    public GeocacheTypeCounter getTotalStats() {
        return this.totalStats;
    }

    public void setTotalStats(GeocacheTypeCounter counter) {
        this.totalStats = counter;
    }

    protected void updateIndexes(FieldNoteItem item) {
        this.fileLogTypeIndex.add(item);
        this.dayLogTypeIndex.add(item);
    }

    public void skipped(FieldNoteItem item) {
        AssertUtils.notNull(item, "Item");
        this.updateIndexes(item);
    }

    public void logged(FieldNoteItem item) {
        AssertUtils.notNull(item, "Item");
        this.updateIndexes(item);
        if (GeocacheLogTypeUtils.isFind(item.getLogType())) {
            this.totalStats.add(item);
        }
    }

    public int getCount(GeocacheLogToken token, FieldNoteItem item) {
        String name = token.getName();
        String tag = token.getParam("tag");
        AssertUtils.notNull(name, "Counter Name");
        if (name.equalsIgnoreCase(TOK_TOTAL_FINDS)) {
            return this.totalStats != null ? this.totalStats.getValue() : -1;
        }
        if (name.equalsIgnoreCase(TOK_TOTAL_FINDS_TRADI)) {
            return this.totalStats != null ? this.totalStats.getValueByGroup(GeocacheType.TRADI) : -1;
        }
        if (name.equalsIgnoreCase(TOK_TOTAL_FINDS_MULTI)) {
            return this.totalStats != null ? this.totalStats.getValueByGroup(GeocacheType.MULTI) : -1;
        }
        if (name.equalsIgnoreCase(TOK_TOTAL_FINDS_VIRTUAL)) {
            return this.totalStats != null ? this.totalStats.getValueByGroup(GeocacheType.VIRT) : -1;
        }
        if (name.equalsIgnoreCase(TOK_TOTAL_FINDS_LETTER)) {
            return this.totalStats != null ? this.totalStats.getValueByGroup(GeocacheType.LETTER) : -1;
        }
        if (name.equalsIgnoreCase(TOK_TOTAL_FINDS_EVENT)) {
            return this.totalStats != null ? this.totalStats.getValueByGroup(GeocacheType.EVENT) : -1;
        }
        if (name.equalsIgnoreCase(TOK_TOTAL_FINDS_CITO)) {
            return this.totalStats != null ? this.totalStats.getValueByGroup(GeocacheType.CITO) : -1;
        }
        if (name.equalsIgnoreCase(TOK_TOTAL_FINDS_MEGA)) {
            return this.totalStats != null ? this.totalStats.getValueByGroup(GeocacheType.MEGA) : -1;
        }
        if (name.equalsIgnoreCase(TOK_TOTAL_FINDS_GIGA)) {
            return this.totalStats != null ? this.totalStats.getValueByGroup(GeocacheType.GIGA) : -1;
        }
        if (name.equalsIgnoreCase(TOK_TOTAL_FINDS_MYSTERY)) {
            return this.totalStats != null ? this.totalStats.getValueByGroup(GeocacheType.UNKNOWN) : -1;
        }
        if (name.equalsIgnoreCase(TOK_TOTAL_FINDS_WEBCAM)) {
            return this.totalStats != null ? this.totalStats.getValueByGroup(GeocacheType.WEBCAM) : -1;
        }
        if (name.equalsIgnoreCase(TOK_TOTAL_FINDS_EARTH)) {
            return this.totalStats != null ? this.totalStats.getValueByGroup(GeocacheType.EARTH) : -1;
        }
        if (name.equalsIgnoreCase(TOK_TOTAL_FINDS_GPS)) {
            return this.totalStats != null ? this.totalStats.getValueByGroup(GeocacheType.GPS) : -1;
        }
        if (name.equalsIgnoreCase(TOK_TOTAL_FINDS_WIGO)) {
            return this.totalStats != null ? this.totalStats.getValueByGroup(GeocacheType.WIGO) : -1;
        }
        if (name.equalsIgnoreCase(TOK_TOTAL_FINDS_LAB)) {
            return this.totalStats != null ? this.totalStats.getValueByGroup(GeocacheType.LAB) : -1;
        }
        if (name.equalsIgnoreCase(TOK_FILE_COUNT)) {
            GeocacheLogTypeCounter cnt = this.fileLogTypeCounter.getCounterByTag(tag);
            return cnt != null ? cnt.getValue() : -1;
        }
        if (name.equalsIgnoreCase(TOK_FILE_COUNT_FINDS)) {
            GeocacheLogTypeCounter cnt = this.fileLogTypeCounter.getCounterByTag(tag);
            return cnt != null ? cnt.getValueByGroup(GeocacheLogType.FOUND_IT) : -1;
        }
        if (name.equalsIgnoreCase(TOK_FILE_COUNT_DNFS)) {
            GeocacheLogTypeCounter cnt = this.fileLogTypeCounter.getCounterByTag(tag);
            return cnt != null ? cnt.getValueByGroup(GeocacheLogType.DNF) : -1;
        }
        if (name.equalsIgnoreCase(TOK_DAY_COUNT)) {
            GeocacheLogTypeCounter cnt;
            GeocacheLogTypeDailyCounter c = this.dayLogTypeCounter.getCounterByTag(tag);
            if (c != null && (cnt = (GeocacheLogTypeCounter)c.getCounterByItem(item)) != null) {
                return cnt.getValue();
            }
            return -1;
        }
        if (name.equalsIgnoreCase(TOK_DAY_COUNT_FINDS)) {
            GeocacheLogTypeCounter cnt;
            GeocacheLogTypeDailyCounter c = this.dayLogTypeCounter.getCounterByTag(tag);
            if (c != null && (cnt = (GeocacheLogTypeCounter)c.getCounterByItem(item)) != null) {
                return cnt.getValueByGroup(GeocacheLogType.FOUND_IT);
            }
            return -1;
        }
        if (name.equalsIgnoreCase(TOK_DAY_COUNT_DNFS)) {
            GeocacheLogTypeCounter cnt;
            GeocacheLogTypeDailyCounter c = this.dayLogTypeCounter.getCounterByTag(tag);
            if (c != null && (cnt = (GeocacheLogTypeCounter)c.getCounterByItem(item)) != null) {
                return cnt.getValueByGroup(GeocacheLogType.DNF);
            }
            return -1;
        }
        if (name.equalsIgnoreCase(TOK_FILE_INDEX)) {
            GeocacheLogTypeCounter cnt = this.fileLogTypeIndex.getCounterByTag(tag);
            return cnt != null ? cnt.getValue() : -1;
        }
        if (name.equalsIgnoreCase(TOK_FILE_INDEX_FINDS)) {
            GeocacheLogTypeCounter cnt = this.fileLogTypeIndex.getCounterByTag(tag);
            return cnt != null ? cnt.getValueByGroup(GeocacheLogType.FOUND_IT) : -1;
        }
        if (name.equalsIgnoreCase(TOK_FILE_INDEX_DNFS)) {
            GeocacheLogTypeCounter cnt = this.fileLogTypeIndex.getCounterByTag(tag);
            return cnt != null ? cnt.getValueByGroup(GeocacheLogType.DNF) : -1;
        }
        if (name.equalsIgnoreCase(TOK_DAY_INDEX)) {
            GeocacheLogTypeCounter idx;
            GeocacheLogTypeDailyCounter c = this.dayLogTypeIndex.getCounterByTag(tag);
            if (c != null && (idx = (GeocacheLogTypeCounter)c.getCounterByItem(item)) != null) {
                return idx.getValue();
            }
            return -1;
        }
        if (name.equalsIgnoreCase(TOK_DAY_INDEX_FINDS)) {
            GeocacheLogTypeCounter idx;
            GeocacheLogTypeDailyCounter c = this.dayLogTypeIndex.getCounterByTag(tag);
            if (c != null && (idx = (GeocacheLogTypeCounter)c.getCounterByItem(item)) != null) {
                return idx.getValueByGroup(GeocacheLogType.FOUND_IT);
            }
            return -1;
        }
        if (name.equalsIgnoreCase(TOK_DAY_INDEX_DNFS)) {
            GeocacheLogTypeCounter idx;
            GeocacheLogTypeDailyCounter c = this.dayLogTypeIndex.getCounterByTag(tag);
            if (c != null && (idx = (GeocacheLogTypeCounter)c.getCounterByItem(item)) != null) {
                return idx.getValueByGroup(GeocacheLogType.DNF);
            }
            return -1;
        }
        return -1;
    }
}

