/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.stats;

import geocentral.common.data.FieldNoteItem;
import geocentral.common.stats.AbstractGroupedCounter;
import geocentral.common.stats.GeocacheLogTypeCounter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import org.bacza.utils.DateUtils;

public class GeocacheLogTypeDailyCounter
extends AbstractGroupedCounter<FieldNoteItem, Date, GeocacheLogTypeCounter> {
    private final boolean aggregateFinds;

    public GeocacheLogTypeDailyCounter(boolean aggregateFinds) {
        this.aggregateFinds = aggregateFinds;
    }

    @Override
    protected GeocacheLogTypeCounter createCounter() {
        return new GeocacheLogTypeCounter(this.aggregateFinds);
    }

    @Override
    public Date getGroupKey(FieldNoteItem item) {
        if (item != null) {
            return item.getLogDate();
        }
        return null;
    }

    @Override
    public Date convertGroupKey(Date group) {
        return DateUtils.truncate(group);
    }

    public String toString() {
        ArrayList dates = new ArrayList(this.countersByGroup.keySet());
        Collections.sort(dates);
        StringBuilder sb = new StringBuilder(512);
        sb.append(String.format("$day.count: %s%n", this.counterTotal));
        for (Date date : dates) {
            GeocacheLogTypeCounter counter = (GeocacheLogTypeCounter)this.countersByGroup.get(date);
            sb.append(String.format("$day.count: %s: %s%n", DateUtils.formatDate(date), counter));
        }
        return sb.toString();
    }
}

