/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.stats;

import geocentral.common.data.FieldNoteItem;
import geocentral.common.stats.ICounter;
import java.util.HashSet;
import java.util.Set;
import org.bacza.utils.AssertUtils;
import org.bacza.utils.StringUtils;

public class FieldNoteIntCounter
implements ICounter<FieldNoteItem> {
    private int value = 0;
    private final Set<String> set = new HashSet<String>();

    @Override
    public void add(FieldNoteItem item) {
        String code = this.getKey(item);
        if (this.set.add(code)) {
            ++this.value;
        }
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public void setValue(int value) {
        if (this.set.size() > 0) {
            throw new IllegalStateException("Not supported!");
        }
        this.value = value;
    }

    protected String getKey(FieldNoteItem item) {
        AssertUtils.notNull(item, "Item");
        String key = StringUtils.toUpperCase(item.getGeocacheCode());
        if (key == null) {
            key = StringUtils.toUpperCase(item.getGuid());
        }
        AssertUtils.notNull(key, "Key");
        return key;
    }
}

