/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.stats;

import geocentral.common.stats.ICounter;
import geocentral.common.stats.IGroupedCounter;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractGroupedCounter<I, G, C extends ICounter<I>>
implements IGroupedCounter<I, G, C> {
    protected C counterTotal = this.createCounter();
    protected Map<G, C> countersByGroup = new HashMap<G, C>();

    protected abstract C createCounter();

    public abstract G getGroupKey(I var1);

    public G convertGroupKey(G group) {
        return group;
    }

    public boolean isIncludedInTotal(G group) {
        return true;
    }

    protected int recalcTotal() {
        int result = 0;
        for (Map.Entry<G, C> entry : this.countersByGroup.entrySet()) {
            ICounter counter;
            if (!this.isIncludedInTotal(entry.getKey()) || (counter = (ICounter)entry.getValue()) == null) continue;
            result += counter.getValue();
        }
        return result;
    }

    protected C getCounterByGroupImpl(G group, boolean create) {
        if (group != null) {
            ICounter<Object> counter = (ICounter)this.countersByGroup.get(group);
            if (counter == null && create) {
                counter = this.createCounter();
                this.countersByGroup.put(group, counter);
            }
            return (C)counter;
        }
        return null;
    }

    protected C getCounterByItemImpl(I item, boolean create) {
        return this.getCounterByGroupImpl(this.convertGroupKey(this.getGroupKey(item)), create);
    }

    @Override
    public C getCounterByGroup(G group) {
        return this.getCounterByGroupImpl(this.convertGroupKey(group), false);
    }

    @Override
    public C getCounterByItem(I item) {
        return this.getCounterByItemImpl(item, false);
    }

    @Override
    public C getTotalCounter() {
        return this.counterTotal;
    }

    @Override
    public void add(I item) {
        if (item != null) {
            G group = this.convertGroupKey(this.getGroupKey(item));
            if (group != null) {
                C counter = this.getCounterByGroupImpl(group, true);
                counter.add(item);
            }
            if (this.isIncludedInTotal(group)) {
                this.counterTotal.add(item);
            }
        }
    }

    @Override
    public int getValue() {
        return this.counterTotal.getValue();
    }

    @Override
    public void setValue(int value) {
    }

    @Override
    public int getValueByGroup(G group) {
        C counter = this.getCounterByGroupImpl(this.convertGroupKey(group), false);
        if (counter != null) {
            return counter.getValue();
        }
        return 0;
    }

    @Override
    public void setValueByGroup(G group, int value) {
        C counter = this.getCounterByGroupImpl(this.convertGroupKey(group), true);
        if (counter != null) {
            counter.setValue(value);
            this.counterTotal.setValue(this.recalcTotal());
        }
    }
}

