/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.sql;

import geocentral.common.sql.DAO;
import geocentral.common.sql.SQLUtils;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import org.bacza.utils.AssertUtils;
import org.bacza.utils.FileUtils;

public abstract class SimpleDAO<T>
extends DAO<T> {
    public SimpleDAO(Connection conn) {
        super(conn);
    }

    protected static String getSql(String path) {
        return SimpleDAO.getSql(SimpleDAO.class, path);
    }

    protected static String getSql(Class<?> clazz, String path) {
        try {
            return FileUtils.readResourceAsString(clazz, path);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("SQL resource not found");
        }
    }

    @Override
    public void cleanupSchema() throws SQLException {
        String[] sqls = this.getCleanupSchemaSqls();
        AssertUtils.notNull(sqls, "Cleanup schema SQLs");
        String[] stringArray = sqls;
        int n = sqls.length;
        int n2 = 0;
        while (n2 < n) {
            String sql = stringArray[n2];
            AssertUtils.notNull(sql, "Cleanup schema SQL");
            SQLUtils.executeUpdate(this.getConnection(), sql);
            ++n2;
        }
    }

    @Override
    public void dropSchema() throws SQLException {
        String[] sqls = this.getDropSchemaSqls();
        AssertUtils.notNull(sqls, "Drop schema SQLs");
        String[] stringArray = sqls;
        int n = sqls.length;
        int n2 = 0;
        while (n2 < n) {
            String sql = stringArray[n2];
            AssertUtils.notNull(sql, "Drop schema SQL");
            SQLUtils.executeUpdate(this.getConnection(), sql);
            ++n2;
        }
    }

    @Override
    public void createSchema() throws SQLException {
        String[] sqls = this.getCreateSchemaSqls();
        AssertUtils.notNull(sqls, "Create schema SQLs");
        String[] stringArray = sqls;
        int n = sqls.length;
        int n2 = 0;
        while (n2 < n) {
            String sql = stringArray[n2];
            AssertUtils.notNull(sql, "Create schema SQL");
            SQLUtils.executeUpdate(this.getConnection(), sql);
            ++n2;
        }
    }

    @Override
    public void insert(T item) throws SQLException {
        AssertUtils.notNull(item, "Item");
        String sql = this.getInsertSql();
        AssertUtils.notNull(sql, "Insert SQL");
        Throwable throwable = null;
        Object var4_5 = null;
        try (PreparedStatement st = this.prepareStatement(sql);){
            this.setValues(st, item);
            st.executeUpdate();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void insert(List<T> items) throws SQLException {
        AssertUtils.notNull(items, "Items");
        String sql = this.getInsertSql();
        AssertUtils.notNull(sql, "Insert SQL");
        Throwable throwable = null;
        Object var4_5 = null;
        try (PreparedStatement st = this.prepareStatement(sql);){
            for (T item : items) {
                this.setValues(st, item);
                st.executeUpdate();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<T> select() throws SQLException {
        String sql = this.getSelectSql();
        AssertUtils.notNull(sql, "Select SQL");
        LinkedList<T> items = new LinkedList<T>();
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            Statement st = this.createStatement();
            try {
                try (ResultSet rs = st.executeQuery(sql);){
                    while (rs.next()) {
                        T item = this.createItem();
                        AssertUtils.notNull(item, "Item");
                        this.getValues(rs, item);
                        items.add(item);
                    }
                }
                if (st == null) return items;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (st == null) throw throwable;
                st.close();
                throw throwable;
            }
            st.close();
            return items;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    protected abstract String[] getCleanupSchemaSqls();

    protected abstract String[] getDropSchemaSqls();

    protected abstract String[] getCreateSchemaSqls();

    protected abstract String getInsertSql();

    protected abstract String getSelectSql();

    protected abstract void setValues(PreparedStatement var1, T var2) throws SQLException;

    protected abstract void getValues(ResultSet var1, T var2) throws SQLException;

    protected abstract T createItem();
}

