/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.sql;

import geocentral.common.data.FieldNoteItem;
import geocentral.common.data.FieldNoteStatus;
import geocentral.common.data.FieldNoteType;
import geocentral.common.geocaching.GeocacheLogType;
import geocentral.common.geocaching.GeocacheSite;
import geocentral.common.geocaching.GeocacheSize;
import geocentral.common.geocaching.GeocacheType;
import geocentral.common.sql.FieldNoteItemDAO;
import geocentral.common.sql.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.bacza.http.URLUtils;
import org.bacza.utils.EnumUtils;

public class FieldNoteItemDAOv10
extends FieldNoteItemDAO {
    private static final String[] cleanupSqls = new String[]{FieldNoteItemDAOv10.getSql("/sql/fieldnotes/fino_vacuum.sql")};
    private static final String[] dropSqls = new String[]{FieldNoteItemDAOv10.getSql("/sql/fieldnotes/fino_drop_table_v10.sql")};
    private static final String[] createSqls = new String[]{FieldNoteItemDAOv10.getSql("/sql/fieldnotes/fino_create_table_v10.sql"), FieldNoteItemDAOv10.getSql("/sql/fieldnotes/fino_create_indexes_v10.sql")};
    private static final String insertSql = FieldNoteItemDAOv10.getSql("/sql/fieldnotes/fino_insert_v10.sql");
    private static final String selectSql = FieldNoteItemDAOv10.getSql("/sql/fieldnotes/fino_select_v10.sql");

    public FieldNoteItemDAOv10(Connection conn) {
        super(conn);
    }

    @Override
    protected String[] getCleanupSchemaSqls() {
        return cleanupSqls;
    }

    @Override
    protected String[] getDropSchemaSqls() {
        return dropSqls;
    }

    @Override
    protected String[] getCreateSchemaSqls() {
        return createSqls;
    }

    @Override
    protected String getInsertSql() {
        return insertSql;
    }

    @Override
    protected String getSelectSql() {
        return selectSql;
    }

    @Override
    protected void setValues(PreparedStatement st, FieldNoteItem item) throws SQLException {
        SQLUtils.setString(st, 1, EnumUtils.getName(item.getFieldNoteType()));
        SQLUtils.setString(st, 2, EnumUtils.getName(item.getFieldNoteStatus()));
        SQLUtils.setString(st, 3, EnumUtils.getName(item.getSite()));
        SQLUtils.setString(st, 4, item.getGeocacheCode());
        SQLUtils.setString(st, 5, item.getGeocacheName());
        SQLUtils.setString(st, 6, item.getGeocacheOwner());
        SQLUtils.setString(st, 7, item.getGuid());
        SQLUtils.setString(st, 8, EnumUtils.getName(item.getType()));
        SQLUtils.setString(st, 9, EnumUtils.getName(item.getSize()));
        SQLUtils.setDouble(st, 10, item.getRatingDifficulty());
        SQLUtils.setDouble(st, 11, item.getRatingTerrain());
        SQLUtils.setDate(st, 12, item.getLogDate());
        SQLUtils.setString(st, 13, EnumUtils.getName(item.getLogType()));
        SQLUtils.setString(st, 14, item.getLogText());
        SQLUtils.setDate(st, 15, item.getExistingLogDate());
        SQLUtils.setString(st, 16, EnumUtils.getName(item.getExistingLogType()));
        SQLUtils.setBoolean(st, 17, item.isExistingLogChecked());
        SQLUtils.setString(st, 18, URLUtils.toASCIIString(item.getComposeLink()));
        SQLUtils.setString(st, 19, URLUtils.toASCIIString(item.getDeleteLink()));
        SQLUtils.setBoolean(st, 20, item.getFavourite());
        SQLUtils.setBoolean(st, 21, item.getVisitTrackables());
    }

    @Override
    protected void getValues(ResultSet rs, FieldNoteItem item) throws SQLException {
        item.setFieldNoteType(EnumUtils.getEnum(FieldNoteType.class, rs.getString(1)));
        item.setFieldNoteStatus(EnumUtils.getEnum(FieldNoteStatus.class, rs.getString(2)));
        item.setSite(EnumUtils.getEnum(GeocacheSite.class, rs.getString(3)));
        item.setGeocacheCode(rs.getString(4));
        item.setGeocacheName(rs.getString(5));
        item.setGeocacheOwner(rs.getString(6));
        item.setGuid(rs.getString(7));
        item.setType(EnumUtils.getEnum(GeocacheType.class, rs.getString(8)));
        item.setSize(EnumUtils.getEnum(GeocacheSize.class, rs.getString(9)));
        item.setRatingDifficulty(SQLUtils.getDouble(rs, 10));
        item.setRatingTerrain(SQLUtils.getDouble(rs, 11));
        item.setLogDate(rs.getDate(12));
        item.setLogType(EnumUtils.getEnum(GeocacheLogType.class, rs.getString(13)));
        item.setLogText(rs.getString(14));
        item.setExistingLogDate(rs.getDate(15));
        item.setExistingLogType(EnumUtils.getEnum(GeocacheLogType.class, rs.getString(16)));
        item.setExistingLogChecked(rs.getBoolean(17));
        item.setComposeLink(URLUtils.create(rs.getString(18)));
        item.setDeleteLink(URLUtils.create(rs.getString(19)));
        item.setFavourite(rs.getBoolean(20));
        item.setVisitTrackables(rs.getBoolean(21));
    }
}

