/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.sql;

import geocentral.common.sql.DAO;
import geocentral.common.sql.IDAOProvider;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bacza.utils.AssertUtils;

public class DAOManager<I> {
    private static final Log log = LogFactory.getLog(DAOManager.class);
    protected final Map<String, IDAOProvider<I>> map = new HashMap<String, IDAOProvider<I>>();

    public void register(IDAOProvider<I> provider) {
        AssertUtils.notNull(provider, "Provider");
        String daoId = provider.getDAOId();
        AssertUtils.notNull(daoId, "DAO Id");
        String daoVer = provider.getDAOVersion();
        AssertUtils.notNull(daoVer, "DAO Version");
        AssertUtils.checkState(!this.map.containsKey(daoVer), "DAO Version already registered!");
        this.map.put(daoVer, provider);
    }

    public <T extends DAO<I>> T createDAO(String version, Connection conn) {
        IDAOProvider<I> provider = this.map.get(version);
        if (provider != null) {
            log.trace((Object)String.format("Creating DAO: %s (%s)", provider.getDAOId(), provider.getDAOVersion()));
            return (T)provider.createDAO(conn);
        }
        return null;
    }
}

