/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.bacza.utils.AssertUtils;

public abstract class DAO<T> {
    private final Connection conn;

    public DAO(Connection conn) {
        AssertUtils.notNull(conn, "Connection");
        this.conn = conn;
    }

    protected Statement createStatement() throws SQLException {
        Statement st = this.conn.createStatement();
        this.configureStatement(st);
        return st;
    }

    protected PreparedStatement prepareStatement(String sql) throws SQLException {
        PreparedStatement st = this.conn.prepareStatement(sql);
        this.configureStatement(st);
        return st;
    }

    protected void configureStatement(Statement st) throws SQLException {
        AssertUtils.notNull(st, "Statement");
        st.setQueryTimeout(30);
    }

    public Connection getConnection() {
        return this.conn;
    }

    public abstract void cleanupSchema() throws SQLException;

    public abstract void dropSchema() throws SQLException;

    public abstract void createSchema() throws SQLException;

    public abstract void insert(T var1) throws SQLException;

    public abstract void insert(List<T> var1) throws SQLException;

    public abstract List<T> select() throws SQLException;
}

