/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.services;

import geocentral.common.services.WorkerService;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class WorkerServiceLoader {
    private static final Log log = LogFactory.getLog(WorkerServiceLoader.class);
    private static final WorkerServiceLoader instance = new WorkerServiceLoader();
    private ServiceLoader<WorkerService> loader = ServiceLoader.load(WorkerService.class);

    public static WorkerServiceLoader getInstance() {
        return instance;
    }

    private WorkerServiceLoader() {
        this.initServices();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initServices() {
        Iterator<WorkerService> iter = this.loader.iterator();
        try {
            while (true) {
                if (!iter.hasNext()) {
                    return;
                }
                try {
                    WorkerService worker = iter.next();
                    worker.initService();
                }
                catch (ServiceConfigurationError e) {
                    log.debug((Object)String.format("Error: %s", e.getMessage()));
                }
            }
        }
        catch (ServiceConfigurationError e) {
            log.debug((Object)String.format("Error: %s", e.getMessage()));
        }
    }
}

