/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.plugins;

import geocentral.common.GlobalUtils;
import geocentral.common.app.UsageServiceUtils;
import geocentral.common.plugins.AsyncContext;
import geocentral.common.plugins.IAsyncAction;
import geocentral.common.ui.DialogUtils;
import geocentral.common.ui.DisplayUtils;
import geocentral.common.ui.MessageUtils;
import geocentral.common.ui.ThreadSafeProgressMonitor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bacza.utils.AssertUtils;
import org.bacza.utils.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;

public final class PluginExecutor {
    private static final Log log = LogFactory.getLog(PluginExecutor.class);
    private static final PluginExecutor instance = new PluginExecutor();
    public static final int MAX_THREADS = 1;
    private Object lock = new Object();
    private int allRunningActions = 0;
    private IAsyncAction currentAsyncAction = null;

    public static PluginExecutor getInstance() {
        return instance;
    }

    private PluginExecutor() {
    }

    private void executeImpl(IAsyncAction action) {
        this.onExecuteStart(action);
        String actionClassName = action.getClass().getSimpleName();
        UsageServiceUtils.actionExecuted(actionClassName);
        try {
            try {
                action.execute();
            }
            catch (Exception e) {
                log.debug((Object)"Error executing action", (Throwable)e);
                MessageUtils.showException(e);
                this.onExecuteStop(action);
            }
        }
        finally {
            this.onExecuteStop(action);
        }
    }

    private boolean executeInBackground(final IAsyncAction action) {
        String name = action.getTaskName();
        AssertUtils.checkArgument(StringUtils.notEmpty(name), "Task name may not be empty.");
        AsyncContext ctx = new AsyncContext(new ThreadSafeProgressMonitor(this.getAppProgressMonitor()));
        action.setAsyncContext(ctx);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                PluginExecutor.this.executeImpl(action);
            }
        };
        new Thread(runnable).start();
        return true;
    }

    private boolean executeInDialog(final IAsyncAction action) {
        boolean result = false;
        String name = action.getTaskName();
        AssertUtils.checkArgument(StringUtils.notEmpty(name), "Task name may not be empty.");
        try {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    AsyncContext ctx = new AsyncContext(monitor);
                    action.setAsyncContext(ctx);
                    PluginExecutor.this.executeImpl(action);
                }
            };
            ProgressMonitorDialog pmd = new ProgressMonitorDialog(DisplayUtils.getShell());
            pmd.setCancelable(true);
            pmd.run(true, true, runnable);
            result = true;
        }
        catch (InvocationTargetException e) {
            log.debug((Object)"Error", (Throwable)e);
        }
        catch (InterruptedException e) {
            log.debug((Object)"Error", (Throwable)e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onExecuteStart(IAsyncAction action) {
        Object object = this.lock;
        synchronized (object) {
            this.currentAsyncAction = action;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onExecuteStop(IAsyncAction action) {
        Object object = this.lock;
        synchronized (object) {
            if (this.allRunningActions > 0) {
                --this.allRunningActions;
            }
            this.currentAsyncAction = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAsyncAction getCurrentAsyncAction() {
        Object object = this.lock;
        synchronized (object) {
            return this.currentAsyncAction;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean execute(IAsyncAction action, boolean modal) {
        Object object = this.lock;
        synchronized (object) {
            block5: {
                if (this.allRunningActions < 1) break block5;
                DialogUtils.showInfo("Poczekaj na zako\u0144czenie zadania w tle.");
                return false;
            }
            ++this.allRunningActions;
        }
        if (modal) {
            return this.executeInDialog(action);
        }
        return this.executeInBackground(action);
    }

    public boolean executeSync(IAsyncAction action) {
        return this.execute(action, true);
    }

    public boolean executeAsync(IAsyncAction action) {
        return this.execute(action, false);
    }

    protected IProgressMonitor getAppProgressMonitor() {
        StatusLineManager status = (StatusLineManager)GlobalUtils.getInstance().getData("geocentral.main.status");
        status.setCancelEnabled(true);
        return status.getProgressMonitor();
    }
}

