/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.plugins;

import geocentral.common.plugins.ContextData;
import geocentral.common.plugins.IConcurrencyContext;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

class ContextRepo {
    private Map<IConcurrencyContext, ContextData> map = new HashMap<IConcurrencyContext, ContextData>();

    ContextRepo() {
    }

    public ContextData getContextData(IConcurrencyContext ctx) {
        ContextData result = null;
        if (ctx != null && (result = this.map.get(ctx)) == null) {
            result = this.createContextData(ctx);
        }
        return result;
    }

    private ContextData createContextData(IConcurrencyContext ctx) {
        LinkedList<IConcurrencyContext> list = new LinkedList<IConcurrencyContext>();
        while (ctx != null) {
            if (list.contains(ctx)) {
                throw new IllegalArgumentException("Concurrency context loop detected!");
            }
            list.addFirst(ctx);
            ctx = ctx.getParent();
        }
        ContextData last = null;
        for (IConcurrencyContext cc : list) {
            ContextData cd = this.map.get(cc);
            if (cd == null) {
                cd = new ContextData(cc, last);
                this.map.put(cc, cd);
            }
            last = cd;
        }
        return last;
    }
}

