/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.plugins;

import geocentral.common.plugins.IConcurrencyContext;

class ContextData {
    private IConcurrencyContext ctx;
    private int runningActions;
    private int enqueuedActions;
    private ContextData parent;

    ContextData(IConcurrencyContext ctx, ContextData parent) {
        this.ctx = ctx;
        this.runningActions = 0;
        this.enqueuedActions = 0;
        this.parent = parent;
    }

    public void actionStarted() {
        if (this.parent != null) {
            this.parent.actionStarted();
        }
        ++this.runningActions;
    }

    public void actionStopped() {
        if (this.parent != null) {
            this.parent.actionStopped();
        }
        if (this.runningActions > 0) {
            --this.runningActions;
        }
    }

    public void actionEnqueued() {
        if (this.parent != null) {
            this.parent.actionEnqueued();
        }
        ++this.enqueuedActions;
    }

    public void actionDequeued() {
        if (this.parent != null) {
            this.parent.actionDequeued();
        }
        if (this.enqueuedActions > 0) {
            --this.enqueuedActions;
        }
    }

    public boolean canExecuteAction() {
        if (this.parent != null && !this.parent.canExecuteAction()) {
            return false;
        }
        int max = this.ctx.getMaxRunningActions();
        return max > this.runningActions;
    }

    public boolean canEnqueueAction() {
        if (this.parent != null && !this.parent.canEnqueueAction()) {
            return false;
        }
        int max = this.ctx.getMaxPendingActions();
        return max > this.enqueuedActions || max <= 0;
    }
}

