/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.map;

import geocentral.common.map.Bounds;
import geocentral.common.map.Coords;

public final class LatLonUtils {
    public static final double RADIUS = 6371000.0;
    private static final double MIN_LAT = Math.toRadians(-90.0);
    private static final double MAX_LAT = Math.toRadians(90.0);
    private static final double MIN_LON = Math.toRadians(-180.0);
    private static final double MAX_LON = Math.toRadians(180.0);

    private static boolean checkCoords(Coords p) {
        return p != null && p.isInitialized();
    }

    private static boolean checkCoords(Coords p1, Coords p2) {
        return LatLonUtils.checkCoords(p1) && LatLonUtils.checkCoords(p2);
    }

    public static double distance(Coords p1, Coords p2) {
        if (LatLonUtils.checkCoords(p1, p2)) {
            return LatLonUtils.distance(p1.getLat(), p1.getLon(), p2.getLat(), p2.getLon());
        }
        throw new IllegalArgumentException("Invalid coords");
    }

    public static double distance(double lat1, double lon1, double lat2, double lon2) {
        double dLat = Math.toRadians(lat2 - lat1);
        double dLon = Math.toRadians(lon2 - lon1);
        double a = Math.sin(dLat / 2.0) * Math.sin(dLat / 2.0) + Math.cos(Math.toRadians(lat1)) * Math.cos(Math.toRadians(lat2)) * Math.sin(dLon / 2.0) * Math.sin(dLon / 2.0);
        double c = 2.0 * Math.asin(Math.sqrt(a));
        return 6371000.0 * c;
    }

    public static double bearing(Coords p1, Coords p2) {
        if (LatLonUtils.checkCoords(p1, p2)) {
            return LatLonUtils.bearing(p1.getLat(), p1.getLon(), p2.getLat(), p2.getLon());
        }
        throw new IllegalArgumentException("Invalid coords");
    }

    public static double bearing(double lat1, double lon1, double lat2, double lon2) {
        double lat1r = Math.toRadians(lat1);
        double lat2r = Math.toRadians(lat2);
        double dLon = Math.toRadians(lon2 - lon1);
        double y = Math.sin(dLon) * Math.cos(lat2r);
        double x = Math.cos(lat1r) * Math.sin(lat2r) - Math.sin(lat1r) * Math.cos(lat2r) * Math.cos(dLon);
        double brng = Math.atan2(y, x);
        return (Math.toDegrees(brng) + 360.0) % 360.0;
    }

    public static Coords destination(Coords start, double bearing, double distance) {
        Coords result = new Coords();
        LatLonUtils.destination(start, bearing, distance, result);
        return result;
    }

    public static void destination(Coords start, double bearing, double distance, Coords result) {
        if (result == null) {
            return;
        }
        result.reset();
        if (!LatLonUtils.checkCoords(start)) {
            return;
        }
        bearing = Math.toRadians(bearing);
        double lat1 = Math.toRadians(start.getLat());
        double lon1 = Math.toRadians(start.getLon());
        double lat2 = Math.asin(Math.sin(lat1) * Math.cos(distance /= 6371000.0) + Math.cos(lat1) * Math.sin(distance) * Math.cos(bearing));
        double lon2 = lon1 + Math.atan2(Math.sin(bearing) * Math.sin(distance) * Math.cos(lat1), Math.cos(distance) - Math.sin(lat1) * Math.sin(lat2));
        lon2 = (lon2 + Math.PI * 3) % (Math.PI * 2) - Math.PI;
        result.set(Math.toDegrees(lat2), Math.toDegrees(lon2));
    }

    public static Coords midpoint(Coords p1, Coords p2) {
        Coords result = new Coords();
        LatLonUtils.midpoint(p1, p2, result);
        return result;
    }

    public static void midpoint(Coords p1, Coords p2, Coords result) {
        if (result == null) {
            return;
        }
        result.reset();
        if (!LatLonUtils.checkCoords(p1, p2)) {
            return;
        }
        double dLon = Math.toRadians(p2.getLon() - p1.getLon());
        double lat1 = Math.toRadians(p1.getLat());
        double lon1 = Math.toRadians(p1.getLon());
        double lat2 = Math.toRadians(p2.getLat());
        double Bx = Math.cos(lat2) * Math.cos(dLon);
        double By = Math.cos(lat2) * Math.sin(dLon);
        double lat3 = Math.atan2(Math.sin(lat1) + Math.sin(lat2), Math.sqrt((Math.cos(lat1) + Bx) * (Math.cos(lat1) + Bx) + By * By));
        double lon3 = lon1 + Math.atan2(By, Math.cos(lat1) + Bx);
        lon3 = (lon3 + Math.PI * 3) % (Math.PI * 2) - Math.PI;
        result.set(Math.toDegrees(lat3), Math.toDegrees(lon3));
    }

    public static Coords intersection(Coords p1, double brng1, Coords p2, double brng2) {
        double brng21;
        double brng12;
        if (!LatLonUtils.checkCoords(p1, p2)) {
            return null;
        }
        double lat1 = Math.toRadians(p1.getLat());
        double lon1 = Math.toRadians(p1.getLon());
        double lat2 = Math.toRadians(p2.getLat());
        double lon2 = Math.toRadians(p2.getLon());
        double brng13 = Math.toRadians(brng1);
        double brng23 = Math.toRadians(brng2);
        double dLat = lat2 - lat1;
        double dLon = lon2 - lon1;
        double dist12 = 2.0 * Math.asin(Math.sqrt(Math.sin(dLat / 2.0) * Math.sin(dLat / 2.0) + Math.cos(lat1) * Math.cos(lat2) * Math.sin(dLon / 2.0) * Math.sin(dLon / 2.0)));
        if (dist12 == 0.0) {
            return null;
        }
        double brngA = Math.acos((Math.sin(lat2) - Math.sin(lat1) * Math.cos(dist12)) / (Math.sin(dist12) * Math.cos(lat1)));
        if (Double.isNaN(brngA)) {
            brngA = 0.0;
        }
        double brngB = Math.acos((Math.sin(lat1) - Math.sin(lat2) * Math.cos(dist12)) / (Math.sin(dist12) * Math.cos(lat2)));
        if (Math.sin(lon2 - lon1) > 0.0) {
            brng12 = brngA;
            brng21 = Math.PI * 2 - brngB;
        } else {
            brng12 = Math.PI * 2 - brngA;
            brng21 = brngB;
        }
        double alpha1 = (brng13 - brng12 + Math.PI) % (Math.PI * 2) - Math.PI;
        double alpha2 = (brng21 - brng23 + Math.PI) % (Math.PI * 2) - Math.PI;
        if (Math.sin(alpha1) == 0.0 && Math.sin(alpha2) == 0.0) {
            return null;
        }
        if (Math.sin(alpha1) * Math.sin(alpha2) < 0.0) {
            return null;
        }
        double alpha3 = Math.acos(-Math.cos(alpha1) * Math.cos(alpha2) + Math.sin(alpha1) * Math.sin(alpha2) * Math.cos(dist12));
        double dist13 = Math.atan2(Math.sin(dist12) * Math.sin(alpha1) * Math.sin(alpha2), Math.cos(alpha2) + Math.cos(alpha1) * Math.cos(alpha3));
        double lat3 = Math.asin(Math.sin(lat1) * Math.cos(dist13) + Math.cos(lat1) * Math.sin(dist13) * Math.cos(brng13));
        double dLon13 = Math.atan2(Math.sin(brng13) * Math.sin(dist13) * Math.cos(lat1), Math.cos(dist13) - Math.sin(lat1) * Math.sin(lat3));
        double lon3 = lon1 + dLon13;
        lon3 = (lon3 + Math.PI * 3) % (Math.PI * 2) - Math.PI;
        return new Coords(Math.toDegrees(lat3), Math.toDegrees(lon3));
    }

    public static Bounds boundingBox(Coords point, double distance) {
        double maxLon;
        double minLon;
        if (!LatLonUtils.checkCoords(point) || distance < 0.0) {
            return null;
        }
        double radDist = distance / 6371000.0;
        double radLat = Math.toRadians(point.getLat());
        double radLon = Math.toRadians(point.getLon());
        double minLat = radLat - radDist;
        double maxLat = radLat + radDist;
        if (minLat > MIN_LAT && maxLat < MAX_LAT) {
            double deltaLon = Math.asin(Math.sin(radDist) / Math.cos(radLat));
            minLon = radLon - deltaLon;
            if (minLon < MIN_LON) {
                minLon += Math.PI * 2;
            }
            if ((maxLon = radLon + deltaLon) > MAX_LON) {
                maxLon -= Math.PI * 2;
            }
        } else {
            minLat = Math.max(minLat, MIN_LAT);
            maxLat = Math.min(maxLat, MAX_LAT);
            minLon = MIN_LON;
            maxLon = MAX_LON;
        }
        return new Bounds(Math.toDegrees(minLat), Math.toDegrees(minLon), Math.toDegrees(maxLat), Math.toDegrees(maxLon));
    }
}

