/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.map;

import geocentral.common.map.Coords;
import java.util.Locale;
import org.bacza.utils.StringUtils;

public final class CoordsUtils {
    public static Coords parseCoordsPipe(String str) {
        String[] tokens;
        if (StringUtils.notEmpty(str) && (tokens = str.split("\\|", 3)).length == 2) {
            try {
                double lat = Double.parseDouble(tokens[0]);
                double lon = Double.parseDouble(tokens[1]);
                return new Coords(lat, lon);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    public static String formatPipe(Coords coords) {
        if (coords != null) {
            return CoordsUtils.formatPipe(coords.getLat(), coords.getLon());
        }
        return null;
    }

    public static String formatPipe(Double lat, Double lon) {
        if (lat != null && lon != null) {
            return String.format(Locale.US, "%.6f|%.6f", lat, lon);
        }
        return null;
    }
}

