/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.map;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Point;
import geocentral.common.geometry.GeometryService;
import java.util.Locale;

public class Coords {
    private Double lat;
    private Double lon;
    private Point point;

    private static String format(Double value) {
        return String.format(Locale.US, "%.6f", value);
    }

    public String toString() {
        return String.format("[%s, %s]", Coords.format(this.lat), Coords.format(this.lon));
    }

    public boolean isInitialized() {
        return this.lat != null && this.lon != null;
    }

    public Double getLat() {
        return this.lat;
    }

    public void setLat(Double value) {
        this.lat = value;
        this.initPoint();
    }

    public Double getLon() {
        return this.lon;
    }

    public void setLon(Double value) {
        this.lon = value;
        this.initPoint();
    }

    public Point getPoint() {
        return this.point;
    }

    public void setPoint(Point point) {
        this.point = point;
    }

    public Coords() {
        this.reset();
    }

    public Coords(Double lat, Double lon) {
        this.set(lat, lon);
    }

    public Coords(Coords coords) {
        this.set(coords);
    }

    public void reset() {
        this.lat = null;
        this.lon = null;
        this.point = null;
    }

    public void set(Double lat, Double lon) {
        this.lat = lat;
        this.lon = lon;
        this.initPoint();
    }

    public void set(Coords coords) {
        this.setLat(coords == null ? null : coords.getLat());
        this.setLon(coords == null ? null : coords.getLon());
    }

    public boolean setMin(double lat, double lon) {
        boolean modified = false;
        if (this.isInitialized()) {
            if (lat < this.lat) {
                this.setLat(lat);
                modified = true;
            }
            if (lon < this.lon) {
                this.setLon(lon);
                modified = true;
            }
        } else {
            this.setLat(lat);
            this.setLon(lon);
            modified = true;
        }
        return modified;
    }

    public boolean setMax(double lat, double lon) {
        boolean modified = false;
        if (this.isInitialized()) {
            if (lat > this.lat) {
                this.setLat(lat);
                modified = true;
            }
            if (lon > this.lon) {
                this.setLon(lon);
                modified = true;
            }
        } else {
            this.setLat(lat);
            this.setLon(lon);
            modified = true;
        }
        return modified;
    }

    public boolean isLessEqual(Coords other) {
        if (this.isInitialized() && other != null && other.isInitialized()) {
            return this.lat <= other.lat && this.lon <= other.lon;
        }
        return false;
    }

    public boolean isGreaterEqual(Coords other) {
        if (this.isInitialized() && other != null && other.isInitialized()) {
            return this.lat >= other.lat && this.lon >= other.lon;
        }
        return false;
    }

    private void initPoint() {
        if (this.lat != null && this.lon != null) {
            this.setPoint(GeometryService.getInstance().getGeometryFactory().createPoint(new Coordinate(this.lat.doubleValue(), this.lon.doubleValue())));
        } else {
            this.setPoint(null);
        }
    }
}

