/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.map;

import geocentral.common.map.Coords;
import geocentral.common.map.LatLonUtils;
import java.util.Locale;

public class Bounds {
    private Coords sw;
    private Coords ne;
    private Coords mid;

    public Bounds() {
        this.reset();
    }

    public Bounds(Coords latlon1, Coords latlon2) {
        this.reset(latlon1, latlon2);
    }

    public Bounds(Bounds bounds) {
        this.reset(bounds);
    }

    public Bounds(double lat_lo, double lon_lo, double lat_hi, double lon_hi) {
        this.reset(lat_lo, lon_lo, lat_hi, lon_hi);
    }

    public boolean isInitialized() {
        return this.sw.isInitialized() && this.ne.isInitialized();
    }

    public Coords getSw() {
        return this.sw;
    }

    public Coords getNe() {
        return this.ne;
    }

    public Coords getMid() {
        return this.mid;
    }

    public void reset() {
        this.sw = new Coords();
        this.ne = new Coords();
        this.mid = new Coords();
    }

    public void reset(Coords latlon1, Coords latlon2) {
        this.reset();
        this.extend(latlon1);
        this.extend(latlon2);
    }

    public void reset(Bounds bounds) {
        this.reset();
        this.extend(bounds);
    }

    public void reset(double lat_lo, double lon_lo, double lat_hi, double lon_hi) {
        this.reset();
        this.extend(lat_lo, lon_lo);
        this.extend(lat_hi, lon_hi);
    }

    public void extend(Coords latlon) {
        if (latlon != null && latlon.isInitialized()) {
            this.extend(latlon.getLat(), latlon.getLon());
        }
    }

    public void extend(double lat, double lon) {
        if (this.isInitialized()) {
            boolean modified = false;
            if (this.sw.setMin(lat, lon)) {
                modified = true;
            }
            if (this.ne.setMax(lat, lon)) {
                modified = true;
            }
            if (modified) {
                LatLonUtils.midpoint(this.sw, this.ne, this.mid);
            }
        } else {
            this.sw.set(lat, lon);
            this.ne.set(lat, lon);
            this.mid.set(lat, lon);
        }
    }

    public void extend(Bounds bounds) {
        this.union(bounds);
    }

    public void union(Bounds bounds) {
        if (bounds != null && bounds.isInitialized()) {
            this.extend(bounds.getSw());
            this.extend(bounds.getNe());
        }
    }

    public boolean contain(Coords latlon) {
        if (this.isInitialized() && latlon != null) {
            return this.sw.isLessEqual(latlon) && this.ne.isGreaterEqual(latlon);
        }
        return false;
    }

    public boolean contain(Bounds bounds) {
        if (this.isInitialized() && bounds != null) {
            return this.sw.isLessEqual(bounds.getNe()) && this.ne.isGreaterEqual(bounds.getSw());
        }
        return false;
    }

    public String toUrl(char delim) {
        if (this.isInitialized()) {
            return String.format(Locale.US, "%f%c%f%c%f%c%f", this.sw.getLat(), Character.valueOf(delim), this.sw.getLon(), Character.valueOf(delim), this.ne.getLat(), Character.valueOf(delim), this.ne.getLon());
        }
        return "";
    }

    public String toUrlLonLat(char delim) {
        if (this.isInitialized()) {
            return String.format(Locale.US, "%f%c%f%c%f%c%f", this.sw.getLon(), Character.valueOf(delim), this.sw.getLat(), Character.valueOf(delim), this.ne.getLon(), Character.valueOf(delim), this.ne.getLat());
        }
        return "";
    }

    public String toString() {
        return this.toUrl(',');
    }
}

