/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.items;

import geocentral.common.data.IDataItem;
import geocentral.common.items.WaypointItem;
import geocentral.common.map.Bounds;
import geocentral.common.map.Coords;
import java.util.LinkedList;
import java.util.List;

public class TrackSegment
implements IDataItem {
    private static final long serialVersionUID = -4979164282573064523L;
    private Bounds bounds = new Bounds();
    private List<WaypointItem> waypoints = new LinkedList<WaypointItem>();

    @Override
    public String getItemId() {
        return String.format("%s", this.bounds);
    }

    public Bounds getBounds() {
        return this.bounds;
    }

    public List<WaypointItem> getWaypoints() {
        return this.waypoints;
    }

    public int getWaypointCount() {
        return this.waypoints.size();
    }

    public void addWaypoint(WaypointItem wpt) {
        Coords latlon;
        if (wpt != null && (latlon = wpt.getCoords()) != null && latlon.isInitialized()) {
            this.waypoints.add(wpt);
            this.bounds.extend(wpt.getCoords());
        }
    }
}

