/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.items;

import geocentral.common.geocaching.GeocacheSize;
import geocentral.common.geocaching.GeocacheType;
import geocentral.common.items.GeocacheLog;
import geocentral.common.items.GeocacheUser;
import geocentral.common.items.ISiteItem;
import geocentral.common.items.MapItem;
import geocentral.common.items.WaypointItem;
import geocentral.common.map.IWaypointMapItem;
import java.io.Serializable;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.bacza.utils.ObjectUtils;

public abstract class Geocache
extends MapItem
implements IWaypointMapItem,
ISiteItem {
    public static final String ID = "geocentral.common.items.Geocache";
    private static final long serialVersionUID = -3666165137337994728L;
    private String code;
    private String srcId;
    private String uuid;
    private GeocacheType type;
    private GeocacheSize size;
    private String symbol;
    private String name;
    private GeocacheUser owner;
    private Double ratingDifficulty;
    private Double ratingTerrain;
    private Double ratingUser;
    private String description;
    private Boolean descriptionHtml;
    private String hint;
    private String url;
    private String imageUrl;
    private Date hidden;
    private String country;
    private String state;
    private int logCount;
    private List<GeocacheLog> logs = new LinkedList<GeocacheLog>();

    protected abstract String getSiteInternal();

    public Geocache() {
    }

    public Geocache(String code, double lat, double lon, String name) {
        this();
        this.setCode(code);
        this.setLat(lat);
        this.setLon(lon);
        this.setName(name);
    }

    public void initialize(WaypointItem item) {
        if (item != null) {
            this.setCode(item.getName());
            this.setLat(item.getLat());
            this.setLon(item.getLon());
            this.setHidden(item.getDate());
            this.setSymbol(item.getSymbol());
            this.setUrl(item.getUrl());
        }
    }

    public int hashCode() {
        return ObjectUtils.hashCode(this.code);
    }

    public boolean equals(Object obj) {
        if (ObjectUtils.equalClass(this, obj)) {
            Geocache other = (Geocache)obj;
            return ObjectUtils.equal(this.code, other.code);
        }
        return false;
    }

    public String toString() {
        return String.format("[%s] [%s]", this.code, this.name);
    }

    @Override
    public String getItemId() {
        return this.code;
    }

    public Serializable getPrimaryKey() {
        return this.getCode();
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Override
    public String getSite() {
        return this.getSiteInternal();
    }

    public void setSite(String site) {
    }

    @Override
    public String getSrcId() {
        return this.srcId;
    }

    public void setSrcId(String srcId) {
        this.srcId = srcId;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public GeocacheType getType() {
        return this.type;
    }

    public void setType(GeocacheType geocacheType) {
        this.type = geocacheType;
    }

    public GeocacheSize getSize() {
        return this.size;
    }

    public void setSize(GeocacheSize size) {
        this.size = size;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public GeocacheUser getOwner() {
        return this.owner;
    }

    public void setOwner(GeocacheUser owner) {
        this.owner = owner;
    }

    public Double getRatingDifficulty() {
        return this.ratingDifficulty;
    }

    public void setRatingDifficulty(Double ratingDifficulty) {
        this.ratingDifficulty = ratingDifficulty;
    }

    public Double getRatingTerrain() {
        return this.ratingTerrain;
    }

    public void setRatingTerrain(Double ratingTerrain) {
        this.ratingTerrain = ratingTerrain;
    }

    public Double getRatingUser() {
        return this.ratingUser;
    }

    public void setRatingUser(Double ratingUser) {
        this.ratingUser = ratingUser;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean getDescriptionHtml() {
        return this.descriptionHtml;
    }

    public void setDescriptionHtml(Boolean descriptionHtml) {
        this.descriptionHtml = descriptionHtml;
    }

    public String getHint() {
        return this.hint;
    }

    public void setHint(String hint) {
        this.hint = hint;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public Date getHidden() {
        return this.hidden;
    }

    public void setHidden(Date hidden) {
        this.hidden = hidden;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public int getLogCount() {
        return this.logCount;
    }

    public void setLogCount(int logCount) {
        this.logCount = logCount;
    }

    public List<GeocacheLog> getLogs() {
        return this.logs;
    }

    public void setLogs(List<GeocacheLog> logs) {
        this.logs = logs;
    }

    public void addLog(GeocacheLog log) {
        log.setGeocache(this);
        this.logs.add(log);
        this.logCount = this.logs.size();
    }
}

