/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.geometry;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.index.SpatialIndex;
import com.vividsolutions.jts.index.strtree.STRtree;
import geocentral.common.data.IDataItem;
import geocentral.common.geometry.GeometryService;
import geocentral.common.map.Coords;
import geocentral.common.map.IMapItem;
import geocentral.common.map.IWaypointMapItem;
import java.util.List;

public final class GeometryUtils {
    private static final GeometryFactory gf = GeometryService.getInstance().getGeometryFactory();

    public static Coordinate latlonToCoord(Coords latlon) {
        if (latlon != null) {
            return new Coordinate(latlon.getLon().doubleValue(), latlon.getLat().doubleValue());
        }
        return null;
    }

    public static SpatialIndex createIndex(List<IDataItem> items) {
        STRtree index = null;
        if (items != null && items.size() > 0) {
            index = new STRtree();
            for (IDataItem item : items) {
                Point point;
                Envelope env;
                Coords latlon;
                if (!(item instanceof IWaypointMapItem) || (latlon = ((IWaypointMapItem)item).getCoords()) == null || !latlon.isInitialized() || (env = (point = gf.createPoint(GeometryUtils.latlonToCoord(latlon))).getEnvelopeInternal()).isNull()) continue;
                point.setUserData((Object)item);
                index.insert(env, (Object)point);
            }
        }
        return index;
    }

    public static IMapItem searchIndex(SpatialIndex index, Coords latlon) {
        IMapItem result = null;
        if (index != null && latlon != null && latlon.isInitialized()) {
            Envelope search = new Envelope(GeometryUtils.latlonToCoord(latlon));
            search.expandBy(2.0E-4);
            List items = index.query(search);
            if (items != null && items.size() > 0) {
                for (Object object : items) {
                    Object data;
                    if (!(object instanceof Point) || !((data = ((Point)object).getUserData()) instanceof IMapItem)) continue;
                    result = (IMapItem)data;
                }
            }
        }
        return result;
    }

    public static void test() {
    }
}

