/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.geometry;

public final class BearingUtils {
    public static final String[] DIRECTIONS = new String[]{"N", "NNE", "NE", "ENE", "E", "ESE", "SE", "SSE", "S", "SSW", "SW", "WSW", "W", "WNW", "NW", "NNW"};
    private static final String EMPTY = "";

    public static String bearingAsString(double brng) {
        return BearingUtils.bearingAsString(brng, 8);
    }

    public static String bearingAsString(double brng, int n) {
        if (brng < 0.0) {
            return EMPTY;
        }
        if (n != 4 && n != 8 && n != 16) {
            return EMPTY;
        }
        if (brng >= 360.0) {
            brng %= 360.0;
        }
        double delta = 180.0 / (double)n;
        double slice = (brng + delta) * (double)n / 360.0;
        int index = (int)Math.floor(slice);
        if ((index = index * DIRECTIONS.length / n) >= 0 && index <= DIRECTIONS.length) {
            return DIRECTIONS[index % DIRECTIONS.length];
        }
        return EMPTY;
    }
}

