/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.geocaching.api;

import geocentral.common.app.UserProfile;
import geocentral.common.geocaching.GeocacheSite;
import geocentral.common.geocaching.api.GeocachingApiService;
import geocentral.common.geocaching.api.IGeocachingApi;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.bacza.utils.AssertUtils;
import org.bacza.utils.IOUtils;

public class GeocachingApiManager
implements Closeable {
    private final UserProfile profile;
    private final Map<GeocacheSite, IGeocachingApi> apis;

    public GeocachingApiManager(UserProfile profile) {
        AssertUtils.notNull(profile, "profile");
        this.profile = profile;
        this.apis = new HashMap<GeocacheSite, IGeocachingApi>();
    }

    public IGeocachingApi getGeocachingApi(GeocacheSite site) {
        AssertUtils.notNull((Object)site, "site");
        if (!this.apis.containsKey((Object)site)) {
            this.apis.put(site, GeocachingApiService.getInstance().createApi(site, this.profile));
        }
        return this.apis.get((Object)site);
    }

    @Override
    public void close() throws IOException {
        for (IGeocachingApi api : this.apis.values()) {
            IOUtils.close(api);
        }
    }
}

