/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.geocaching;

import geocentral.api.groundspeak.mappers.GCSiteImageProvider;
import geocentral.api.opencaching.mappers.OCSiteImageProvider;
import geocentral.api.opencaching.mappers.OPSiteImageProvider;
import geocentral.common.geocaching.GeocacheSite;
import geocentral.common.geocaching.GeocacheType;
import geocentral.common.geocaching.IGeocacheType2ImageMapper;
import geocentral.common.geocaching.ISiteImageProvider;
import java.util.HashMap;
import java.util.Map;
import org.bacza.utils.AssertUtils;
import org.eclipse.swt.graphics.Image;

public final class SiteImageProviderService {
    private static final SiteImageProviderService instance = new SiteImageProviderService();
    private final Map<GeocacheSite, ISiteImageProvider> providers = new HashMap<GeocacheSite, ISiteImageProvider>();
    private final Map<GeocacheSite, IGeocacheType2ImageMapper> typeMappers = new HashMap<GeocacheSite, IGeocacheType2ImageMapper>();

    private SiteImageProviderService() {
        this.registerSiteImageProvider(new GCSiteImageProvider());
        this.registerSiteImageProvider(new OPSiteImageProvider());
        this.registerSiteImageProvider(new OCSiteImageProvider());
    }

    public static SiteImageProviderService getInstance() {
        return instance;
    }

    public void registerSiteImageProvider(ISiteImageProvider provider) {
        AssertUtils.notNull(provider, "provider");
        GeocacheSite site = provider.getSite();
        IGeocacheType2ImageMapper mapper = provider.getGeocacheTypeMapper();
        AssertUtils.notNull((Object)site, "site");
        AssertUtils.notNull(mapper, "geocache type mapper");
        this.providers.put(site, provider);
        this.typeMappers.put(site, mapper);
    }

    public IGeocacheType2ImageMapper getGeocacheTypeMapper(GeocacheSite site) {
        if (site != null) {
            return this.typeMappers.get((Object)site);
        }
        return null;
    }

    public Image getSiteLogo(GeocacheSite site) {
        return this.getSiteLogo(site, null);
    }

    public Image getSiteLogo(GeocacheSite site, Image defaultImage) {
        Image image;
        ISiteImageProvider provider;
        if (site != null && (provider = this.providers.get((Object)site)) != null && (image = provider.getSiteLogo()) != null) {
            return image;
        }
        return defaultImage;
    }

    public Image getSiteIcon(GeocacheSite site) {
        return this.getSiteIcon(site, null);
    }

    public Image getSiteIcon(GeocacheSite site, Image defaultImage) {
        Image image;
        ISiteImageProvider provider;
        if (site != null && (provider = this.providers.get((Object)site)) != null && (image = provider.getSiteIcon()) != null) {
            return image;
        }
        return defaultImage;
    }

    public Image getGeocacheTypeImage(GeocacheSite site, GeocacheType type) {
        return this.getGeocacheTypeImage(site, type, null);
    }

    public Image getGeocacheTypeImage(GeocacheSite site, GeocacheType type, Image defaultImage) {
        IGeocacheType2ImageMapper mapper = this.getGeocacheTypeMapper(site);
        if (mapper != null) {
            return mapper.getMappedValue(type, defaultImage);
        }
        return defaultImage;
    }
}

