/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.geocaching;

public final class RatingUtils {
    public static final double MIN = 1.0;
    public static final double MAX = 5.0;
    public static final double DEFAULT = 1.5;
    private static final double step = 0.5;
    private static final double delta = 0.25;

    public static double round(double value) {
        if (value <= 1.0) {
            return 1.0;
        }
        if (value >= 5.0) {
            return 5.0;
        }
        double result = Math.round(value);
        double diff = value - result;
        if (Math.abs(diff) > 0.25) {
            result = diff > 0.0 ? (result += 0.5) : (result -= 0.5);
        }
        return result;
    }

    public static double parse(String value) {
        return RatingUtils.parse(value, 1.5);
    }

    public static double parse(String value, double defaultValue) {
        if (value != null && value.length() > 0) {
            try {
                return Double.parseDouble(value);
            }
            catch (Exception e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public static double valueOf(Object value) {
        return RatingUtils.valueOf(value, 1.5);
    }

    public static double valueOf(Object value, double defaultValue) {
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Long) {
            return new Double(((Long)value).longValue());
        }
        if (value instanceof Integer) {
            return new Double(((Integer)value).intValue());
        }
        if (value instanceof String) {
            return RatingUtils.parse((String)value, defaultValue);
        }
        return defaultValue;
    }
}

