/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.geocaching;

public enum GeocacheType {
    TRADI("Traditional"),
    MULTI("Multi"),
    VIRT("Virtual"),
    LETTER("Letterbox"),
    EVENT("Event", true),
    UNKNOWN("Unknown"),
    WEBCAM("Webcam"),
    CITO("CITO Event", true),
    EARTH("Earthcache"),
    MEGA("Mega Event", true),
    GIGA("Giga Event", true),
    GPS("GPS Adventures", true),
    WIGO("Wherigo"),
    LOCLESS("Locationless"),
    BENCH("Benchmark"),
    QUIZ("Quiz"),
    MOVING("Moving"),
    OWN("Own"),
    OTHER("Other"),
    PARTY("Block Party", true),
    HQ("HQ Geocache"),
    HQ_CLBR("HQ Celebration", true),
    COMM_CLBR("Community Celebration", true),
    LAB("Lab"),
    DRIVEIN("Drive-In"),
    MATH("Math/Physics");

    private final String text;
    private final boolean event;

    private GeocacheType(String text) {
        this(text, false);
    }

    private GeocacheType(String text, boolean event) {
        this.text = text;
        this.event = event;
    }

    public String text() {
        return this.text;
    }

    public boolean isEvent() {
        return this.event;
    }

    public String toString() {
        return this.text;
    }

    public static String getText(GeocacheType type) {
        return type != null ? type.text() : null;
    }

    public static GeocacheType parse(String str) {
        if (str != null) {
            GeocacheType[] geocacheTypeArray = GeocacheType.values();
            int n = geocacheTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                GeocacheType value = geocacheTypeArray[n2];
                if (str.equals(value.text)) {
                    return value;
                }
                ++n2;
            }
        }
        return null;
    }
}

