/*
 * Decompiled with CFR 0.152.
 */
package geocentral.common.geocaching;

import geocentral.common.data.FieldNoteItem;
import geocentral.common.geocaching.GeocacheLogToken;
import geocentral.common.stats.GeocacheStatsManager;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bacza.data.parsers.ParseException;
import org.bacza.utils.AssertUtils;
import org.bacza.utils.DateUtils;
import org.bacza.utils.StringUtils;

public class GeocacheLogTextConverter {
    private static final Log log = LogFactory.getLog(GeocacheLogTextConverter.class);
    public static final String TOK_CACHE_NAME = "$cache.name";
    public static final String TOK_CACHE_OWNER = "$cache.owner";
    public static final String TOK_LOG_DATE = "$log.date";
    public static final String TOK_LOG_TIME = "$log.time";
    public static final String TOK_FILE_PCT_FINDS = "$file.pct.finds";
    public static final String TOK_FILE_PCT_FINDS_ALL = "$file.pct.finds.all";
    public static final String TOK_DAY_PCT_FINDS = "$day.pct.finds";
    public static final String TOK_DAY_PCT_FINDS_ALL = "$day.pct.finds.all";
    protected static final Set<String> ITEM_TOKENS = new HashSet<String>();
    protected static final Set<String> PCT_TOKENS = new HashSet<String>();
    protected static final Set<String> ALL_TOKENS = new HashSet<String>();
    private static final Pattern pattern;
    private GeocacheStatsManager statsManager;
    private List<String> validTokens;
    private List<String> invalidTokens;
    private List<String> emptyTokens;

    static {
        ITEM_TOKENS.add(TOK_CACHE_NAME);
        ITEM_TOKENS.add(TOK_CACHE_OWNER);
        ITEM_TOKENS.add(TOK_LOG_DATE);
        ITEM_TOKENS.add(TOK_LOG_TIME);
        PCT_TOKENS.add(TOK_FILE_PCT_FINDS);
        PCT_TOKENS.add(TOK_FILE_PCT_FINDS_ALL);
        PCT_TOKENS.add(TOK_DAY_PCT_FINDS);
        PCT_TOKENS.add(TOK_DAY_PCT_FINDS_ALL);
        ALL_TOKENS.addAll(ITEM_TOKENS);
        ALL_TOKENS.addAll(PCT_TOKENS);
        ALL_TOKENS.addAll(GeocacheStatsManager.ALL_TOKENS);
        pattern = Pattern.compile("(\\$[a-z]+(\\.[a-z]+)*)(\\(([^\\)]+)\\))?");
    }

    public GeocacheLogTextConverter() {
        this(null);
    }

    public GeocacheLogTextConverter(GeocacheStatsManager statsManager) {
        this.statsManager = statsManager;
        this.validTokens = new LinkedList<String>();
        this.invalidTokens = new LinkedList<String>();
        this.emptyTokens = new LinkedList<String>();
    }

    protected void reset() {
        this.validTokens.clear();
        this.invalidTokens.clear();
        this.emptyTokens.clear();
    }

    public List<String> getValidTokens() {
        return this.validTokens;
    }

    public List<String> getInvalidTokens() {
        return this.invalidTokens;
    }

    public List<String> getEmptyTokens() {
        return this.emptyTokens;
    }

    public boolean hasValidTokens() {
        return this.validTokens.size() > 0;
    }

    public boolean hasInvalidTokens() {
        return this.invalidTokens.size() > 0;
    }

    public boolean hasEmptyTokens() {
        return this.emptyTokens.size() > 0;
    }

    public boolean hasTokens(String text) {
        this.reset();
        if (StringUtils.notEmpty(text)) {
            Matcher matcher = pattern.matcher(text);
            while (matcher.find()) {
                String match = matcher.group();
                String name = matcher.group(1);
                String params = matcher.group(4);
                try {
                    GeocacheLogToken token = new GeocacheLogToken(name, params);
                    if (ALL_TOKENS.contains(name)) {
                        this.validTokens.add(name);
                        continue;
                    }
                    log.debug((Object)String.format("Invalid token: %s", token));
                    this.invalidTokens.add(name);
                }
                catch (ParseException e) {
                    log.debug((Object)String.format("Error parsing token: %s", match));
                    this.invalidTokens.add(name);
                }
            }
        }
        return this.hasValidTokens() || this.hasInvalidTokens();
    }

    public String convert(String text, FieldNoteItem item) {
        AssertUtils.notNull(item, "Field Note Item");
        this.reset();
        if (StringUtils.notEmpty(text)) {
            StringBuffer sb = new StringBuffer((int)((double)text.length() * 1.2));
            Matcher matcher = pattern.matcher(text);
            while (matcher.find()) {
                String match = matcher.group();
                String name = matcher.group(1);
                String params = matcher.group(4);
                try {
                    GeocacheLogToken token = new GeocacheLogToken(name, params);
                    if (ALL_TOKENS.contains(name)) {
                        this.validTokens.add(name);
                        String value = this.getValue(token, item);
                        if (StringUtils.notEmpty(value)) {
                            matcher.appendReplacement(sb, Matcher.quoteReplacement(value));
                            continue;
                        }
                        log.debug((Object)String.format("Error resolving token: %s", token));
                        this.emptyTokens.add(name);
                        continue;
                    }
                    log.debug((Object)String.format("Invalid token: %s", token));
                    this.invalidTokens.add(name);
                }
                catch (ParseException e) {
                    log.debug((Object)String.format("Error parsing token: %s", match));
                    this.invalidTokens.add(name);
                }
            }
            matcher.appendTail(sb);
            text = sb.toString();
        }
        return text;
    }

    protected String getValue(GeocacheLogToken token, FieldNoteItem item) {
        String name = token.getName();
        if (ITEM_TOKENS.contains(name)) {
            if (name.equals(TOK_CACHE_NAME)) {
                return item.getGeocacheName();
            }
            if (name.equals(TOK_CACHE_OWNER)) {
                return item.getGeocacheOwner();
            }
            if (name.equals(TOK_LOG_DATE)) {
                return DateUtils.formatDate(item.getLogDate(), "yyyy-MM-dd");
            }
            if (name.equals(TOK_LOG_TIME)) {
                return DateUtils.formatDate(item.getLogDate(), "HH:mm");
            }
            return null;
        }
        if (GeocacheStatsManager.ALL_TOKENS.contains(name)) {
            int count = this.statsManager.getCount(token, item);
            if (count >= 0) {
                return Integer.toString(count);
            }
            return null;
        }
        if (PCT_TOKENS.contains(name)) {
            try {
                if (StringUtils.equalsIgnoreCase(name, TOK_FILE_PCT_FINDS)) {
                    return this.calcPct(token, item, true, "$file.index.finds", "$file.count.finds");
                }
                if (StringUtils.equalsIgnoreCase(name, TOK_FILE_PCT_FINDS_ALL)) {
                    return this.calcPct(token, item, true, "$file.index.finds", "$file.count");
                }
                if (StringUtils.equalsIgnoreCase(name, TOK_DAY_PCT_FINDS)) {
                    return this.calcPct(token, item, false, "$day.index.finds", "$day.count.finds");
                }
                if (StringUtils.equalsIgnoreCase(name, TOK_DAY_PCT_FINDS_ALL)) {
                    return this.calcPct(token, item, false, "$day.index.finds", "$day.count");
                }
            }
            catch (ParseException e) {
                return null;
            }
        }
        return null;
    }

    protected String calcPct(GeocacheLogToken token, FieldNoteItem item, boolean checkParams, String name1, String name2) throws ParseException {
        int i = this.statsManager.getCount(new GeocacheLogToken(name1, token.getParams()), item);
        String offset = token.getParam("offset");
        if (checkParams && offset != null) {
            int off = StringUtils.parseInt(offset, -1);
            i = off < 0 ? -1 : (i += off);
        }
        String total = token.getParam("total");
        int n = checkParams && total != null ? StringUtils.parseInt(total, -1) : this.statsManager.getCount(new GeocacheLogToken(name2, token.getParams()), item);
        return this.formatPct(i, n);
    }

    protected String formatPct(int i, int n) {
        if (i < 0 || n < 0) {
            return null;
        }
        if (n == 0) {
            return "0";
        }
        if (i > n) {
            i = n;
        }
        return String.format(Locale.US, "%.0f", Math.floor((double)i / (double)n * 100.0));
    }
}

